/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.state.SwirldStateManagerUtils;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.merkle.StateMetrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;

public class SwirldStateManager {
    private final StateMetrics stateMetrics;
    private final AtomicReference<MerkleNodeState> stateRef = new AtomicReference();
    private final AtomicReference<MerkleNodeState> latestImmutableState = new AtomicReference();
    private final SemanticVersion softwareVersion;
    private final PlatformStateFacade platformStateFacade;

    public SwirldStateManager(@NonNull PlatformContext platformContext, @NonNull Roster roster, @NonNull SemanticVersion softwareVersion, @NonNull PlatformStateFacade platformStateFacade) {
        Objects.requireNonNull(platformContext);
        Objects.requireNonNull(roster);
        this.platformStateFacade = Objects.requireNonNull(platformStateFacade);
        this.stateMetrics = new StateMetrics(platformContext.getMetrics());
        this.softwareVersion = Objects.requireNonNull(softwareVersion);
    }

    public void setState(@NonNull MerkleNodeState state, boolean onInit) {
        Objects.requireNonNull(state);
        state.throwIfDestroyed("state must not be destroyed");
        state.throwIfImmutable("state must be mutable");
        if (onInit && this.stateRef.get() != null) {
            throw new IllegalStateException("Attempt to set initial state when there is already a state reference.");
        }
        this.fastCopyAndUpdateRefs(state);
    }

    public MerkleNodeState getConsensusState() {
        return this.stateRef.get();
    }

    private void fastCopyAndUpdateRefs(MerkleNodeState state) {
        MerkleNodeState newState = SwirldStateManagerUtils.fastCopy(state, this.stateMetrics, this.softwareVersion, this.platformStateFacade);
        this.setLatestImmutableState(state);
        this.updateStateRef(newState);
    }

    private void updateStateRef(MerkleNodeState state) {
        MerkleNodeState currVal = this.stateRef.get();
        if (currVal != null) {
            currVal.release();
        }
        this.stateRef.set(state);
    }

    private void setLatestImmutableState(MerkleNodeState immutableState) {
        State currVal = (State)this.latestImmutableState.get();
        if (currVal != null) {
            currVal.release();
        }
        immutableState.getRoot().reserve();
        this.latestImmutableState.set(immutableState);
    }

    public MerkleNodeState getStateForSigning() {
        this.fastCopyAndUpdateRefs(this.stateRef.get());
        return this.latestImmutableState.get();
    }
}

