/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ExtCodeCopyOperation
extends AbstractOperation {
    public static final Bytes EOF_REPLACEMENT_CODE = Bytes.fromHexString((CharSequence)"0xef00");
    private final boolean enableEIP3540;

    public ExtCodeCopyOperation(GasCalculator gasCalculator) {
        this(gasCalculator, false);
    }

    public ExtCodeCopyOperation(GasCalculator gasCalculator, boolean enableEIP3540) {
        super(60, "EXTCODECOPY", 4, 0, gasCalculator);
        this.enableEIP3540 = enableEIP3540;
    }

    protected long cost(MessageFrame frame, long memOffset, long length, boolean accountIsWarm) {
        return Words.clampedAdd(this.gasCalculator().extCodeCopyOperationGasCost(frame, memOffset, length), accountIsWarm ? this.gasCalculator().getWarmStorageReadCost() : this.gasCalculator().getColdAccountAccessCost());
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Bytes code;
        Address address = Words.toAddress(frame.popStackItem());
        long memOffset = Words.clampedToLong(frame.popStackItem());
        long sourceOffset = Words.clampedToLong(frame.popStackItem());
        long numBytes = Words.clampedToLong(frame.popStackItem());
        boolean accountIsWarm = frame.warmUpAddress(address) || this.gasCalculator().isPrecompile(address);
        long cost = this.cost(frame, memOffset, numBytes, accountIsWarm);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Account account = frame.getWorldUpdater().get(address);
        Bytes bytes = code = account != null ? account.getCode() : Bytes.EMPTY;
        if (this.enableEIP3540 && code.size() >= 2 && code.get(0) == -17 && code.get(1) == 0) {
            frame.writeMemory(memOffset, sourceOffset, numBytes, EOF_REPLACEMENT_CODE);
        } else {
            frame.writeMemory(memOffset, sourceOffset, numBytes, code);
        }
        return new Operation.OperationResult(cost, null);
    }
}

