/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update;

import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.DispatchForResponseCodeHtsCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.HtsCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.UpdateCommonDecoder;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.UpdateCommons;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.update.address_0x167.UpdateDecoder;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UpdateExpiryTranslator
extends AbstractCallTranslator<HtsCallAttempt> {
    public static final SystemContractMethod UPDATE_TOKEN_EXPIRY_INFO_V1 = SystemContractMethod.declare("updateTokenExpiryInfo(address,(uint32,address,uint32))", "(int)").withVariant(SystemContractMethod.Variant.V1).withCategories(SystemContractMethod.Category.UPDATE);
    public static final SystemContractMethod UPDATE_TOKEN_EXPIRY_INFO_V2 = SystemContractMethod.declare("updateTokenExpiryInfo(address,(int64,address,int64))", "(int)").withVariant(SystemContractMethod.Variant.V2).withCategories(SystemContractMethod.Category.UPDATE);
    private final UpdateDecoder decoder;

    @Inject
    public UpdateExpiryTranslator(UpdateDecoder decoder, @NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HTS, systemContractMethodRegistry, contractMetrics);
        this.decoder = decoder;
        this.registerMethods(UPDATE_TOKEN_EXPIRY_INFO_V1, UPDATE_TOKEN_EXPIRY_INFO_V2);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HtsCallAttempt attempt) {
        return attempt.isMethod(UPDATE_TOKEN_EXPIRY_INFO_V1, UPDATE_TOKEN_EXPIRY_INFO_V2);
    }

    @Override
    public Call callFrom(@NonNull HtsCallAttempt attempt) {
        return new DispatchForResponseCodeHtsCall(attempt, this.nominalBodyFor(attempt), UpdateCommons::gasRequirement, UpdateCommonDecoder.FAILURE_CUSTOMIZER);
    }

    private TransactionBody nominalBodyFor(@NonNull HtsCallAttempt attempt) {
        if (Arrays.equals(attempt.selector(), UPDATE_TOKEN_EXPIRY_INFO_V1.selector())) {
            return this.decoder.decodeTokenUpdateExpiryV1(attempt);
        }
        return this.decoder.decodeTokenUpdateExpiryV2(attempt);
    }
}

