/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.validators;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.transaction.FixedCustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.spi.validation.ExpiryValidator;
import com.hedera.node.app.spi.workflows.HandleException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class ConsensusCustomFeesValidator {
    @Inject
    public ConsensusCustomFeesValidator() {
    }

    public void validate(@NonNull ReadableAccountStore accountStore, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull ReadableTokenStore tokenStore, @NonNull List<FixedCustomFee> customFees, @NonNull ExpiryValidator expiryValidator) {
        Objects.requireNonNull(accountStore);
        Objects.requireNonNull(tokenRelationStore);
        Objects.requireNonNull(tokenStore);
        Objects.requireNonNull(customFees);
        Objects.requireNonNull(expiryValidator);
        for (FixedCustomFee fee : customFees) {
            TokenHandlerHelper.getIfUsableForAliasedId((AccountID)fee.feeCollectorAccountIdOrElse(AccountID.DEFAULT), (ReadableAccountStore)accountStore, (ExpiryValidator)expiryValidator, (ResponseCodeEnum)ResponseCodeEnum.INVALID_CUSTOM_FEE_COLLECTOR);
            boolean isSpecified = fee.hasFixedFee();
            HandleException.validateTrue((boolean)isSpecified, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_NOT_FULLY_SPECIFIED);
            this.validateFixedFee(fee, tokenRelationStore, tokenStore);
        }
    }

    private void validateFixedFee(@NonNull FixedCustomFee fee, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull ReadableTokenStore tokenStore) {
        FixedFee fixedFee = fee.fixedFeeOrThrow();
        HandleException.validateTrue((fixedFee.amount() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_MUST_BE_POSITIVE);
        if (fixedFee.hasDenominatingTokenId()) {
            this.validateExplicitTokenDenomination(fee.feeCollectorAccountId(), fixedFee.denominatingTokenId(), fixedFee.amount(), tokenRelationStore, tokenStore);
        }
    }

    private void validateExplicitTokenDenomination(@NonNull AccountID feeCollectorNum, @NonNull TokenID tokenNum, long feeAmount, @NonNull ReadableTokenRelationStore tokenRelationStore, @NonNull ReadableTokenStore tokenStore) {
        Token denomToken = TokenHandlerHelper.getIfUsable((TokenID)tokenNum, (ReadableTokenStore)tokenStore, (TokenHandlerHelper.TokenValidations)TokenHandlerHelper.TokenValidations.REQUIRE_NOT_PAUSED, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID_IN_CUSTOM_FEES);
        if (denomToken.supplyType().equals((Object)TokenSupplyType.FINITE)) {
            HandleException.validateFalse((feeAmount > denomToken.maxSupply() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY);
        }
        HandleException.validateTrue((boolean)this.isFungibleCommon(denomToken.tokenType()), (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON);
        TokenRelation tokenRel = tokenRelationStore.get(feeCollectorNum, tokenNum);
        HandleException.validateTrue((tokenRel != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR);
        HandleException.validateFalse((boolean)tokenRel.frozen(), (ResponseCodeEnum)ResponseCodeEnum.ACCOUNT_FROZEN_FOR_TOKEN);
    }

    private boolean isFungibleCommon(@NonNull TokenType tokenType) {
        return tokenType.equals((Object)TokenType.FUNGIBLE_COMMON);
    }
}

