/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.config;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.node.app.config.ConfigProviderBase;
import com.hedera.node.config.VersionedConfigImpl;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.converter.BytesConverter;
import com.hedera.node.config.converter.CongestionMultipliersConverter;
import com.hedera.node.config.converter.EntityScaleFactorsConverter;
import com.hedera.node.config.converter.LongPairConverter;
import com.hedera.node.config.converter.SemanticVersionConverter;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.BlockNodeConnectionConfig;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.BootstrapConfig;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.FeesConfig;
import com.hedera.node.config.data.FilesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.JumboTransactionsConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.OpsDurationConfig;
import com.hedera.node.config.data.TssConfig;
import com.hedera.node.config.data.VersionConfig;
import com.hedera.node.config.sources.PropertyConfigSource;
import com.hedera.node.config.types.CongestionMultipliers;
import com.hedera.node.config.types.EntityScaleFactors;
import com.hedera.node.config.types.LongPair;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.config.api.converter.ConfigConverter;
import com.swirlds.config.api.source.ConfigSource;
import com.swirlds.config.extensions.sources.SystemEnvironmentConfigSource;
import com.swirlds.config.extensions.sources.SystemPropertiesConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;

public class BootstrapConfigProviderImpl
extends ConfigProviderBase {
    private final Configuration bootstrapConfig;

    public BootstrapConfigProviderImpl() {
        ConfigurationBuilder builder = ConfigurationBuilder.create().withSource((ConfigSource)SystemEnvironmentConfigSource.getInstance()).withSource((ConfigSource)SystemPropertiesConfigSource.getInstance()).withSource((ConfigSource)new PropertyConfigSource("semantic-version.properties", 500)).withConfigDataType(BlockStreamConfig.class).withConfigDataType(BootstrapConfig.class).withConfigDataType(HederaConfig.class).withConfigDataType(FilesConfig.class).withConfigDataType(VersionConfig.class).withConfigDataType(LedgerConfig.class).withConfigDataType(AccountsConfig.class).withConfigDataType(TssConfig.class).withConfigDataType(ContractsConfig.class).withConfigDataType(BlockNodeConnectionConfig.class).withConfigDataType(OpsDurationConfig.class).withConfigDataType(JumboTransactionsConfig.class).withConfigDataType(FeesConfig.class).withConverter(Bytes.class, (ConfigConverter)new BytesConverter()).withConverter(SemanticVersion.class, (ConfigConverter)new SemanticVersionConverter()).withConverter(CongestionMultipliers.class, (ConfigConverter)new CongestionMultipliersConverter()).withConverter(EntityScaleFactors.class, (ConfigConverter)new EntityScaleFactorsConverter()).withConverter(LongPair.class, (ConfigConverter)new LongPairConverter());
        try {
            this.addFileSource(builder, "HEDERA_APP_PROPERTIES_PATH", "data/config/application.properties", 100);
        }
        catch (Exception e) {
            throw new IllegalStateException("Can not create config source for application properties", e);
        }
        this.bootstrapConfig = builder.build();
    }

    @NonNull
    public Configuration configuration() {
        return this.bootstrapConfig;
    }

    @NonNull
    public VersionedConfiguration getConfiguration() {
        return new VersionedConfigImpl(this.bootstrapConfig, 0L);
    }
}

