/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.exports.recordstreaming;

import com.hedera.node.app.hapi.utils.exports.FileCompressionUtils;
import com.hedera.services.stream.proto.RecordStreamFile;
import com.hedera.services.stream.proto.SidecarFile;
import com.hedera.services.stream.proto.SignatureFile;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;

public class RecordStreamingUtils {
    public static final String SIDECAR_ONLY_TOKEN = "Z_";
    public static final String V6_FILE_EXT = ".rcd";
    public static final String V6_GZ_FILE_EXT = ".rcd.gz";
    public static final Comparator<String> SIDECAR_FILE_COMPARATOR = Comparator.comparing(RecordStreamingUtils::parseSidecarFileConsensusTimeAndSequenceNo);

    private RecordStreamingUtils() {
    }

    public static Pair<Integer, Optional<RecordStreamFile>> readMaybeCompressedRecordStreamFile(String loc) throws IOException {
        boolean isCompressed = loc.endsWith(V6_GZ_FILE_EXT);
        return isCompressed ? RecordStreamingUtils.readRecordStreamFile(loc) : RecordStreamingUtils.readUncompressedRecordStreamFile(loc);
    }

    public static Pair<Integer, Optional<RecordStreamFile>> readUncompressedRecordStreamFile(String fileLoc) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileLoc);){
            int recordFileVersion = ByteBuffer.wrap(fin.readNBytes(4)).getInt();
            RecordStreamFile recordStreamFile = RecordStreamFile.parseFrom((InputStream)fin);
            Pair pair = Pair.of((Object)recordFileVersion, Optional.ofNullable(recordStreamFile));
            return pair;
        }
    }

    public static Pair<Integer, Optional<RecordStreamFile>> readRecordStreamFile(String fileLoc) throws IOException {
        byte[] uncompressedFileContents = FileCompressionUtils.readUncompressedFileBytes(fileLoc);
        int recordFileVersion = ByteBuffer.wrap(uncompressedFileContents, 0, 4).getInt();
        RecordStreamFile recordStreamFile = RecordStreamFile.parseFrom((ByteBuffer)ByteBuffer.wrap(uncompressedFileContents, 4, uncompressedFileContents.length - 4));
        return Pair.of((Object)recordFileVersion, Optional.ofNullable(recordStreamFile));
    }

    public static Pair<Integer, Optional<SignatureFile>> readSignatureFile(String fileLoc) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileLoc);){
            int recordFileVersion = fin.read();
            SignatureFile recordStreamSignatureFile = SignatureFile.parseFrom((InputStream)fin);
            Pair pair = Pair.of((Object)recordFileVersion, Optional.ofNullable(recordStreamSignatureFile));
            return pair;
        }
    }

    public static SidecarFile readMaybeCompressedSidecarFile(String loc) throws IOException {
        boolean isCompressed = loc.endsWith(V6_GZ_FILE_EXT);
        return isCompressed ? RecordStreamingUtils.readSidecarFile(loc) : RecordStreamingUtils.readUncompressedSidecarFile(loc);
    }

    public static SidecarFile readUncompressedSidecarFile(String fileLoc) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileLoc);){
            SidecarFile sidecarFile = SidecarFile.parseFrom((InputStream)fin);
            return sidecarFile;
        }
    }

    public static SidecarFile readSidecarFile(String fileLoc) throws IOException {
        return SidecarFile.parseFrom((byte[])FileCompressionUtils.readUncompressedFileBytes(fileLoc));
    }

    public static Instant parseRecordFileConsensusTime(String recordFile) {
        int s = recordFile.lastIndexOf("/");
        int n = recordFile.length();
        if (recordFile.endsWith(V6_FILE_EXT)) {
            return RecordStreamingUtils.parseInstantFrom(recordFile, s + 1, n - V6_FILE_EXT.length());
        }
        if (recordFile.endsWith(V6_GZ_FILE_EXT)) {
            return RecordStreamingUtils.parseInstantFrom(recordFile, s + 1, n - V6_GZ_FILE_EXT.length());
        }
        throw new IllegalArgumentException("Invalid record file name '" + recordFile + "'");
    }

    public static Pair<Instant, Integer> parseSidecarFileConsensusTimeAndSequenceNo(String sidecarFile) {
        int s = sidecarFile.lastIndexOf("/");
        int n = sidecarFile.indexOf(SIDECAR_ONLY_TOKEN, s);
        return Pair.of((Object)RecordStreamingUtils.parseInstantFrom(sidecarFile, s + 1, n + 1), (Object)Integer.parseInt(sidecarFile.substring(n + 2, n + 4)));
    }

    private static Instant parseInstantFrom(String recordOrSidecarFile, int start, int end) {
        return Instant.parse(recordOrSidecarFile.substring(start, end).replace("_", ":"));
    }

    public static List<String> filteredFilesFrom(String streamDir, Predicate<String> criteria, Comparator<String> order) throws IOException {
        return Files.walk(Path.of(streamDir, new String[0]), new FileVisitOption[0]).map(Path::toString).filter(criteria).sorted(order).toList();
    }

    public static List<String> orderedRecordFilesFrom(String streamDir, @NonNull Predicate<String> inclusionTest) throws IOException {
        return RecordStreamingUtils.filteredFilesFrom(streamDir, f -> RecordStreamingUtils.isRecordFile(f) && inclusionTest.test((String)f), Comparator.comparing(RecordStreamingUtils::parseRecordFileConsensusTime));
    }

    public static List<String> orderedSidecarFilesFrom(String streamDir) throws IOException {
        return RecordStreamingUtils.filteredFilesFrom(streamDir, RecordStreamingUtils::isSidecarFile, RecordStreamingUtils::compareSidecarFiles);
    }

    public static boolean isRecordFile(String file) {
        return RecordStreamingUtils.isRelevant(file) && !file.contains(SIDECAR_ONLY_TOKEN);
    }

    public static boolean isSidecarMarkerFile(String file) {
        return file.contains(SIDECAR_ONLY_TOKEN) && file.contains(".mf");
    }

    public static boolean isSidecarFile(String file) {
        return RecordStreamingUtils.isRelevant(file) && file.contains(SIDECAR_ONLY_TOKEN);
    }

    private static boolean isRelevant(String file) {
        return file.endsWith(V6_FILE_EXT) || file.endsWith(V6_GZ_FILE_EXT);
    }

    public static int compareSidecarFiles(String lhs, String rhs) {
        return SIDECAR_FILE_COMPARATOR.compare(lhs, rhs);
    }
}

