/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.entityid.impl;

import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.entity.EntityCounts;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.entityid.ReadableEntityIdStore;
import com.hedera.node.app.service.entityid.impl.schemas.V0490EntityIdSchema;
import com.hedera.node.app.service.entityid.impl.schemas.V0590EntityIdSchema;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class ReadableEntityIdStoreImpl
implements ReadableEntityIdStore {
    private final ReadableSingletonState<EntityNumber> entityIdState;
    private final ReadableSingletonState<EntityCounts> entityCountsState;

    public ReadableEntityIdStoreImpl(@NonNull ReadableStates states) {
        Objects.requireNonNull(states);
        this.entityIdState = states.getSingleton(V0490EntityIdSchema.ENTITY_ID_STATE_ID);
        this.entityCountsState = states.getSingleton(V0590EntityIdSchema.ENTITY_COUNTS_STATE_ID);
    }

    public long peekAtNextNumber() {
        EntityNumber oldEntityNum = (EntityNumber)this.entityIdState.get();
        return oldEntityNum == null ? 1L : oldEntityNum.number() + 1L;
    }

    public long numAccounts() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numAccounts();
    }

    public long numTokens() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numTokens();
    }

    public long numFiles() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numFiles();
    }

    public long numTopics() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numTopics();
    }

    public long numContractBytecodes() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numContractBytecodes();
    }

    public long numContractStorageSlots() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numContractStorageSlots();
    }

    public long numNfts() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numNfts();
    }

    public long numTokenRelations() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numTokenRelations();
    }

    public long numAliases() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numAliases();
    }

    public long numSchedules() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numSchedules();
    }

    public long numAirdrops() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numAirdrops();
    }

    public long getCounterFor(EntityType entityType) {
        EntityCounts entityState = Objects.requireNonNull((EntityCounts)this.entityCountsState.get());
        return switch (entityType) {
            default -> throw new MatchException(null, null);
            case EntityType.ACCOUNT -> entityState.numAccounts();
            case EntityType.TOKEN -> entityState.numTokens();
            case EntityType.NODE -> entityState.numNodes();
            case EntityType.FILE -> entityState.numFiles();
            case EntityType.TOPIC -> entityState.numTopics();
            case EntityType.CONTRACT_BYTECODE -> entityState.numContractBytecodes();
            case EntityType.CONTRACT_STORAGE -> entityState.numContractStorageSlots();
            case EntityType.NFT -> entityState.numNfts();
            case EntityType.TOKEN_ASSOCIATION -> entityState.numTokenRelations();
            case EntityType.ALIAS -> entityState.numAliases();
            case EntityType.SCHEDULE -> entityState.numSchedules();
            case EntityType.AIRDROP -> entityState.numAirdrops();
            case EntityType.STAKING_INFO -> entityState.numStakingInfos();
            case EntityType.HOOK -> entityState.numHooks();
            case EntityType.LAMBDA_STORAGE -> entityState.numLambdaStorageSlots();
        };
    }

    public long numNodes() {
        return Objects.requireNonNull((EntityCounts)this.entityCountsState.get()).numNodes();
    }
}

