/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.helidon;

import com.hedera.pbj.grpc.helidon.DeadlineDetector;
import com.hedera.pbj.grpc.helidon.GrpcHeaders;
import com.hedera.pbj.grpc.helidon.PbjMethodRoute;
import com.hedera.pbj.grpc.helidon.config.PbjConfig;
import com.hedera.pbj.runtime.grpc.GrpcException;
import com.hedera.pbj.runtime.grpc.GrpcStatus;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.helidon.common.buffers.BufferData;
import io.helidon.common.media.type.MediaType;
import io.helidon.common.uri.UriEncoding;
import io.helidon.http.Header;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.Headers;
import io.helidon.http.HttpException;
import io.helidon.http.HttpMediaType;
import io.helidon.http.Status;
import io.helidon.http.WritableHeaders;
import io.helidon.http.http2.FlowControl;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameData;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameTypes;
import io.helidon.http.http2.Http2Headers;
import io.helidon.http.http2.Http2RstStream;
import io.helidon.http.http2.Http2StreamState;
import io.helidon.http.http2.Http2StreamWriter;
import io.helidon.http.http2.Http2WindowUpdate;
import io.helidon.webserver.http2.spi.Http2SubProtocolSelector;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Delayed;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class PbjProtocolHandler
implements Http2SubProtocolSelector.SubProtocolHandler {
    private static final System.Logger LOGGER = System.getLogger(PbjProtocolHandler.class.getName());
    private static final String IDENTITY = "identity";
    private static final Header GRPC_ENCODING_IDENTITY = HeaderValues.createCached((String)"grpc-encoding", (String)"identity");
    private static final String GRPC_TIMEOUT_REGEX = "(\\d{1,8})([HMSmun])";
    private static final Pattern GRPC_TIMEOUT_PATTERN = Pattern.compile("(\\d{1,8})([HMSmun])");
    private final Http2Headers headers;
    private final Http2StreamWriter streamWriter;
    private final int streamId;
    private final FlowControl.Outbound flowControl;
    private final AtomicReference<Http2StreamState> currentStreamState;
    private final PbjMethodRoute route;
    private final PbjConfig config;
    private final DeadlineDetector deadlineDetector;
    private Future<?> deadlineFuture = CompletableFuture.completedFuture(null);
    private byte[] entityBytes = null;
    private int entityBytesIndex = 0;
    private ReadState currentReadState = ReadState.START;
    private int numOfPartReadBytes = 0;
    private final byte[] partReadLengthBytes = new byte[4];
    private Pipeline<? super Bytes> pipeline;

    PbjProtocolHandler(@NonNull Http2Headers headers, @NonNull Http2StreamWriter streamWriter, int streamId, @NonNull FlowControl.Outbound flowControl, @NonNull Http2StreamState currentStreamState, @NonNull PbjConfig config, @NonNull PbjMethodRoute route, @NonNull DeadlineDetector deadlineDetector) {
        this.headers = Objects.requireNonNull(headers);
        this.streamWriter = Objects.requireNonNull(streamWriter);
        this.streamId = streamId;
        this.flowControl = Objects.requireNonNull(flowControl);
        this.currentStreamState = new AtomicReference<Http2StreamState>(Objects.requireNonNull(currentStreamState));
        this.config = Objects.requireNonNull(config);
        this.route = Objects.requireNonNull(route);
        this.deadlineDetector = Objects.requireNonNull(deadlineDetector);
    }

    public void init() {
        this.route.requestCounter().increment();
        try {
            String ct;
            Headers requestHeaders = this.headers.httpHeaders();
            HttpMediaType requestContentType = requestHeaders.contentType().orElse(null);
            String contentType = switch (ct = requestContentType == null ? "" : requestContentType.text()) {
                case "application/grpc", "application/grpc+proto" -> "application/grpc+proto";
                case "application/grpc+json" -> "application/grpc+json";
                default -> {
                    if (ct.startsWith("application/grpc")) {
                        yield ct;
                    }
                    throw new HttpException("invalid gRPC request content-type \"" + ct + "\"", Status.UNSUPPORTED_MEDIA_TYPE_415);
                }
            };
            List encodings = requestHeaders.contains(GrpcHeaders.GRPC_ENCODING) ? requestHeaders.get(GrpcHeaders.GRPC_ENCODING).allValues(true) : List.of(IDENTITY);
            boolean identitySpecified = false;
            for (String encoding : encodings) {
                if (!encoding.startsWith(IDENTITY)) continue;
                identitySpecified = true;
                break;
            }
            if (!identitySpecified) {
                throw new GrpcException(GrpcStatus.UNIMPLEMENTED, "Decompressor is not installed for grpc-encoding \"" + String.join((CharSequence)", ", encodings) + "\"");
            }
            Optional timeout = requestHeaders.value(GrpcHeaders.GRPC_TIMEOUT);
            this.deadlineFuture = timeout.map(this::scheduleDeadline).orElse(new NoopScheduledFuture());
            this.sendResponseHeaders(GRPC_ENCODING_IDENTITY, requestContentType, Collections.emptyList());
            Options options = new Options(Optional.ofNullable(this.headers.authority()), contentType);
            SendToClientSubscriber outgoing = new SendToClientSubscriber();
            this.pipeline = this.route.service().open(this.route.method(), (ServiceInterface.RequestOptions)options, (Pipeline)outgoing);
        }
        catch (GrpcException grpcException) {
            this.route.failedGrpcRequestCounter().increment();
            new TrailerOnlyBuilder(this).grpcStatus(grpcException.status()).statusMessage(grpcException.getMessage()).send();
            this.error();
        }
        catch (HttpException httpException) {
            this.route.failedHttpRequestCounter().increment();
            new TrailerOnlyBuilder(this).httpStatus(httpException.status()).grpcStatus(GrpcStatus.INVALID_ARGUMENT).statusMessage(httpException.getMessage()).send();
            this.error();
        }
        catch (Exception unknown) {
            this.route.failedUnknownRequestCounter().increment();
            LOGGER.log(System.Logger.Level.ERROR, "Failed to initialize grpc protocol handler", (Throwable)unknown);
            new TrailerOnlyBuilder(this).grpcStatus(GrpcStatus.UNKNOWN).send();
            this.error();
        }
    }

    @NonNull
    public Http2StreamState streamState() {
        return this.currentStreamState.get();
    }

    public void rstStream(@NonNull Http2RstStream rstStream) {
        this.pipeline.onComplete();
    }

    public void windowUpdate(@NonNull Http2WindowUpdate update) {
    }

    public void data(@NonNull Http2FrameHeader header, @NonNull BufferData data) {
        Objects.requireNonNull(header);
        Objects.requireNonNull(data);
        try {
            while (data.available() > 0) {
                switch (this.currentReadState.ordinal()) {
                    case 0: {
                        boolean isCompressed;
                        boolean bl = isCompressed = data.read() == 1;
                        if (isCompressed) {
                            throw new GrpcException(GrpcStatus.UNIMPLEMENTED, "Compression is not supported");
                        }
                        this.currentReadState = ReadState.READ_LENGTH;
                        this.numOfPartReadBytes = 0;
                        break;
                    }
                    case 1: {
                        Bytes bytes;
                        if (this.numOfPartReadBytes < 4) {
                            int bytesToRead = Math.min(data.available(), 4 - this.numOfPartReadBytes);
                            data.read(this.partReadLengthBytes, this.numOfPartReadBytes, bytesToRead);
                            this.numOfPartReadBytes += bytesToRead;
                        }
                        if (this.numOfPartReadBytes != 4) break;
                        long length = ((long)this.partReadLengthBytes[0] & 0xFFL) << 24 | ((long)this.partReadLengthBytes[1] & 0xFFL) << 16 | ((long)this.partReadLengthBytes[2] & 0xFFL) << 8 | (long)this.partReadLengthBytes[3] & 0xFFL;
                        if (length > (long)this.config.maxMessageSizeBytes()) {
                            throw new GrpcException(GrpcStatus.INVALID_ARGUMENT, "Message size exceeds maximum allowed size");
                        }
                        if (length == 0L) {
                            bytes = Bytes.EMPTY;
                            this.pipeline.onNext((Object)bytes);
                            this.currentReadState = ReadState.START;
                            break;
                        }
                        this.entityBytes = new byte[(int)length];
                        this.entityBytesIndex = 0;
                        this.currentReadState = ReadState.READ_ENTITY_BYTES;
                        break;
                    }
                    case 2: {
                        int available = data.available();
                        int numBytesToRead = Math.min(this.entityBytes.length - this.entityBytesIndex, available);
                        data.read(this.entityBytes, this.entityBytesIndex, numBytesToRead);
                        this.entityBytesIndex += numBytesToRead;
                        if (this.entityBytesIndex != this.entityBytes.length) break;
                        this.currentReadState = ReadState.START;
                        Bytes bytes = Bytes.wrap((byte[])this.entityBytes);
                        this.pipeline.onNext((Object)bytes);
                        this.entityBytesIndex = 0;
                        this.entityBytes = null;
                        break;
                    }
                }
            }
            if (((Http2Flag.DataFlags)header.flags(Http2FrameTypes.DATA)).endOfStream()) {
                this.entityBytesIndex = 0;
                this.entityBytes = null;
                this.currentStreamState.set(Http2StreamState.CLOSED);
                this.pipeline.clientEndStreamReceived();
            }
        }
        catch (Exception e) {
            this.pipeline.onError((Throwable)e);
        }
    }

    private void error() {
        this.deadlineFuture.cancel(false);
        this.currentStreamState.set(Http2StreamState.CLOSED);
    }

    @NonNull
    private ScheduledFuture<?> scheduleDeadline(@NonNull String timeout) {
        Matcher matcher = GRPC_TIMEOUT_PATTERN.matcher(timeout);
        if (matcher.matches()) {
            int num = Integer.parseInt(matcher.group(1));
            String unit = matcher.group(2);
            long l = System.nanoTime();
            long l2 = num;
            long deadline = l * TimeUnit.NANOSECONDS.convert(l2, switch (unit) {
                case "H" -> TimeUnit.HOURS;
                case "M" -> TimeUnit.MINUTES;
                case "S" -> TimeUnit.SECONDS;
                case "m" -> TimeUnit.MILLISECONDS;
                case "u" -> TimeUnit.MICROSECONDS;
                case "n" -> TimeUnit.NANOSECONDS;
                default -> throw new GrpcException(GrpcStatus.INTERNAL, "Invalid unit: " + unit);
            });
            return this.deadlineDetector.scheduleDeadline(deadline, () -> {
                this.route.deadlineExceededCounter().increment();
                this.pipeline.onError((Throwable)new GrpcException(GrpcStatus.DEADLINE_EXCEEDED));
            });
        }
        return new NoopScheduledFuture();
    }

    private void sendResponseHeaders(@Nullable Header messageEncoding, @NonNull HttpMediaType contentType, @NonNull List<Header> customMetadata) {
        WritableHeaders grpcHeaders = WritableHeaders.create();
        grpcHeaders.set(HeaderNames.TRAILER, new String[]{"grpc-status, grpc-message"});
        grpcHeaders.set(Http2Headers.STATUS_NAME, Status.OK_200.code());
        grpcHeaders.contentType((MediaType)contentType);
        grpcHeaders.set(GrpcHeaders.GRPC_ACCEPT_ENCODING, new String[]{IDENTITY});
        customMetadata.forEach(arg_0 -> ((WritableHeaders)grpcHeaders).set(arg_0));
        if (messageEncoding != null) {
            grpcHeaders.set(messageEncoding);
        }
        Http2Headers http2Headers = Http2Headers.create((WritableHeaders)grpcHeaders);
        this.streamWriter.writeHeaders(http2Headers, this.streamId, Http2Flag.HeaderFlags.create((int)4), this.flowControl);
    }

    static enum ReadState {
        START,
        READ_LENGTH,
        READ_ENTITY_BYTES;

    }

    private static final class NoopScheduledFuture<Void>
    extends CompletableFuture<Void>
    implements ScheduledFuture<Void> {
        private NoopScheduledFuture() {
        }

        @Override
        public long getDelay(@NonNull TimeUnit unit) {
            return 0L;
        }

        @Override
        public int compareTo(@NonNull Delayed o) {
            return (int)o.getDelay(TimeUnit.NANOSECONDS);
        }
    }

    private record Options(Optional<String> authority, String contentType) implements ServiceInterface.RequestOptions
    {
    }

    private final class SendToClientSubscriber
    implements Pipeline<Bytes> {
        private SendToClientSubscriber() {
        }

        public void onSubscribe(@NonNull Flow.Subscription subscription) {
            subscription.request(Long.MAX_VALUE);
        }

        public void onNext(@NonNull Bytes response) {
            try {
                int length = (int)response.length();
                BufferData bufferData = BufferData.create((int)(5 + length));
                bufferData.write(0);
                bufferData.writeUnsignedInt32((long)length);
                bufferData.write(response.toByteArray());
                Http2FrameHeader header = Http2FrameHeader.create((int)bufferData.available(), (Http2FrameTypes)Http2FrameTypes.DATA, (Http2Flag)Http2Flag.DataFlags.create((int)0), (int)PbjProtocolHandler.this.streamId);
                PbjProtocolHandler.this.streamWriter.writeData(new Http2FrameData(header, bufferData), PbjProtocolHandler.this.flowControl);
            }
            catch (Exception e) {
                LOGGER.log(System.Logger.Level.DEBUG, "Failed to respond to grpc request: " + String.valueOf(PbjProtocolHandler.this.route.method()), (Throwable)e);
                PbjProtocolHandler.this.route.failedResponseCounter().increment();
                throw new RuntimeException(e);
            }
        }

        public void onError(@NonNull Throwable throwable) {
            try {
                if (throwable instanceof GrpcException) {
                    GrpcException grpcException = (GrpcException)throwable;
                    new TrailerBuilder().grpcStatus(grpcException.status()).statusMessage(grpcException.getMessage()).send();
                } else {
                    LOGGER.log(System.Logger.Level.DEBUG, "Failed to send response", throwable);
                    new TrailerBuilder().grpcStatus(GrpcStatus.INTERNAL).send();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            PbjProtocolHandler.this.error();
        }

        public void onComplete() {
            new TrailerBuilder().send();
            PbjProtocolHandler.this.deadlineFuture.cancel(false);
            PbjProtocolHandler.this.currentStreamState.getAndUpdate(currentValue -> {
                if (Objects.requireNonNull(currentValue) == Http2StreamState.OPEN) {
                    return Http2StreamState.HALF_CLOSED_LOCAL;
                }
                return Http2StreamState.CLOSED;
            });
        }
    }

    private class TrailerOnlyBuilder
    extends TrailerBuilder {
        private Status httpStatus = Status.OK_200;
        private final HttpMediaType contentType = GrpcHeaders.APPLICATION_GRPC_PROTO_TYPE;

        private TrailerOnlyBuilder(PbjProtocolHandler pbjProtocolHandler) {
        }

        @NonNull
        public TrailerOnlyBuilder httpStatus(@Nullable Status httpStatus) {
            this.httpStatus = httpStatus;
            return this;
        }

        @Override
        protected void send(@NonNull WritableHeaders<?> httpHeaders, @NonNull Http2Headers http2Headers) {
            http2Headers.status(this.httpStatus);
            httpHeaders.contentType((MediaType)Objects.requireNonNull(this.contentType));
            super.send(httpHeaders, http2Headers);
        }
    }

    private class TrailerBuilder {
        @NonNull
        private GrpcStatus grpcStatus = GrpcStatus.OK;
        @Nullable
        private String statusMessage;
        @NonNull
        private final List<Header> customMetadata = Collections.emptyList();

        private TrailerBuilder() {
        }

        @NonNull
        public TrailerBuilder grpcStatus(@NonNull GrpcStatus grpcStatus) {
            this.grpcStatus = grpcStatus;
            return this;
        }

        @NonNull
        public TrailerBuilder statusMessage(@Nullable String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void send() {
            WritableHeaders httpHeaders = WritableHeaders.create();
            Http2Headers http2Headers = Http2Headers.create((WritableHeaders)httpHeaders);
            this.send(httpHeaders, http2Headers);
        }

        protected void send(@NonNull WritableHeaders<?> httpHeaders, @NonNull Http2Headers http2Headers) {
            httpHeaders.set(Objects.requireNonNull(GrpcHeaders.header(Objects.requireNonNull(this.grpcStatus))));
            httpHeaders.set(GrpcHeaders.GRPC_ACCEPT_ENCODING, new String[]{PbjProtocolHandler.IDENTITY});
            this.customMetadata.forEach(arg_0 -> httpHeaders.set(arg_0));
            if (this.statusMessage != null) {
                String percentEncodedMessage = UriEncoding.encodeUri((String)this.statusMessage);
                httpHeaders.set(GrpcHeaders.GRPC_MESSAGE, new String[]{percentEncodedMessage});
            }
            PbjProtocolHandler.this.streamWriter.writeHeaders(http2Headers, PbjProtocolHandler.this.streamId, Http2Flag.HeaderFlags.create((int)5), PbjProtocolHandler.this.flowControl);
            PbjProtocolHandler.this.currentStreamState.set(Http2StreamState.CLOSED);
        }
    }
}

