/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ExpOperation
extends AbstractOperation {
    static final BigInteger MOD_BASE = BigInteger.TWO.pow(256);

    public ExpOperation(GasCalculator gasCalculator) {
        super(10, "EXP", 2, 1, gasCalculator);
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        return ExpOperation.staticOperation(frame, this.gasCalculator());
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame, GasCalculator gasCalculator) {
        byte[] powBytes;
        BigInteger powBI;
        Bytes number = frame.popStackItem();
        Bytes power = frame.popStackItem();
        int numBytes = (power.bitLength() + 7) / 8;
        long cost = gasCalculator.expOperationGasCost(numBytes);
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        byte[] numberBytes = number.toArrayUnsafe();
        BigInteger numBI = numberBytes.length > 0 ? new BigInteger(1, numberBytes) : BigInteger.ZERO;
        BigInteger result = numBI.modPow(powBI = (powBytes = power.toArrayUnsafe()).length > 0 ? new BigInteger(1, powBytes) : BigInteger.ZERO, MOD_BASE);
        byte[] resultArray = result.toByteArray();
        int length = resultArray.length;
        if (length > 32) {
            frame.pushStackItem(Bytes.wrap((byte[])resultArray, (int)(length - 32), (int)32));
        } else {
            frame.pushStackItem(Bytes.wrap((byte[])resultArray));
        }
        return new Operation.OperationResult(cost, null);
    }
}

