/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.worldstate;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hyperledger.besu.collections.trie.BytesTrieSet;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.worldstate.JournaledUpdater;
import org.hyperledger.besu.evm.worldstate.StackedUpdater;
import org.hyperledger.besu.evm.worldstate.UpdateTrackingAccount;
import org.hyperledger.besu.evm.worldstate.WorldUpdater;
import org.hyperledger.besu.evm.worldstate.WorldView;

public abstract class AbstractWorldUpdater<W extends WorldView, A extends Account>
implements WorldUpdater {
    private final W world;
    private final EvmConfiguration evmConfiguration;
    protected Map<Address, UpdateTrackingAccount<A>> updatedAccounts = new ConcurrentHashMap<Address, UpdateTrackingAccount<A>>();
    protected Set<Address> deletedAccounts = Collections.synchronizedSet(new BytesTrieSet(20));

    protected AbstractWorldUpdater(W world, EvmConfiguration evmConfiguration) {
        this.world = world;
        this.evmConfiguration = evmConfiguration;
    }

    protected abstract A getForMutation(Address var1);

    protected UpdateTrackingAccount<A> track(UpdateTrackingAccount<A> account) {
        Address address = account.getAddress();
        this.updatedAccounts.put(address, account);
        this.deletedAccounts.remove(address);
        return account;
    }

    @Override
    public MutableAccount createAccount(Address address, long nonce, Wei balance) {
        UpdateTrackingAccount account = new UpdateTrackingAccount(address);
        account.setNonce(nonce);
        account.setBalance(balance);
        return this.track(account);
    }

    @Override
    public Account get(Address address) {
        MutableAccount existing = this.updatedAccounts.get(address);
        if (existing != null) {
            return existing;
        }
        if (this.deletedAccounts.contains(address)) {
            return null;
        }
        return this.getForMutation(address);
    }

    @Override
    public MutableAccount getAccount(Address address) {
        MutableAccount existing = this.updatedAccounts.get(address);
        if (existing != null) {
            return existing;
        }
        if (this.deletedAccounts.contains(address)) {
            return null;
        }
        A origin = this.getForMutation(address);
        if (origin == null) {
            return null;
        }
        return this.track(new UpdateTrackingAccount<A>(origin));
    }

    @Override
    public void deleteAccount(Address address) {
        this.deletedAccounts.add(address);
        this.updatedAccounts.remove(address);
    }

    @Override
    public WorldUpdater updater() {
        return switch (this.evmConfiguration.worldUpdaterMode()) {
            default -> throw new MatchException(null, null);
            case EvmConfiguration.WorldUpdaterMode.STACKED -> new StackedUpdater(this, this.evmConfiguration);
            case EvmConfiguration.WorldUpdaterMode.JOURNALED -> new JournaledUpdater(this, this.evmConfiguration);
        };
    }

    protected W wrappedWorldView() {
        return this.world;
    }

    @Override
    public Optional<WorldUpdater> parentUpdater() {
        W w = this.world;
        if (w instanceof WorldUpdater) {
            WorldUpdater worldUpdater = (WorldUpdater)w;
            return Optional.of(worldUpdater);
        }
        return Optional.empty();
    }

    protected Collection<UpdateTrackingAccount<A>> getUpdatedAccounts() {
        return this.updatedAccounts.values();
    }

    protected Collection<Address> getDeletedAccounts() {
        return this.deletedAccounts;
    }

    protected void reset() {
        this.updatedAccounts.clear();
        this.deletedAccounts.clear();
    }
}

