/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.configurable.ThreadPool;
import io.helidon.common.configurable.ThreadPoolConfigBlueprint;
import io.helidon.common.configurable.ThreadPoolSupplier;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.configurable.ThreadPoolConfigBlueprint")
public interface ThreadPoolConfig
extends ThreadPoolConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ThreadPoolConfig instance) {
        return (Builder)ThreadPoolConfig.builder().from(instance);
    }

    public static ThreadPoolConfig create(Config config) {
        return ((Builder)ThreadPoolConfig.builder().config(config)).buildPrototype();
    }

    public static ThreadPoolConfig create() {
        return ThreadPoolConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ThreadPoolConfig>
    implements io.helidon.common.Builder<Builder, ThreadPoolSupplier> {
        private Builder() {
        }

        public ThreadPoolConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ThreadPoolConfigImpl(this);
        }

        public ThreadPoolSupplier build() {
            return ThreadPoolSupplier.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ThreadPoolConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private boolean daemon = true;
        private boolean shouldPrestart = true;
        private boolean virtualThreads;
        private Config config;
        private Duration keepAlive = Duration.parse("PT3M");
        private int corePoolSize = 10;
        private int growthRate = 0;
        private int growthThreshold = 1000;
        private int maxPoolSize = 50;
        private int queueCapacity = 10000;
        private ThreadPool.RejectionHandler rejectionHandler = ThreadPoolSupplier.DEFAULT_REJECTION_POLICY;
        private String name;
        private String threadNamePrefix;

        protected BuilderBase() {
        }

        public BUILDER from(ThreadPoolConfig prototype) {
            this.virtualThreads(prototype.virtualThreads());
            this.corePoolSize(prototype.corePoolSize());
            this.maxPoolSize(prototype.maxPoolSize());
            this.keepAlive(prototype.keepAlive());
            this.queueCapacity(prototype.queueCapacity());
            this.daemon(prototype.daemon());
            this.name(prototype.name());
            this.growthThreshold(prototype.growthThreshold());
            this.growthRate(prototype.growthRate());
            this.rejectionHandler(prototype.rejectionHandler());
            this.threadNamePrefix(prototype.threadNamePrefix());
            this.shouldPrestart(prototype.shouldPrestart());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.virtualThreads(builder.virtualThreads());
            this.corePoolSize(builder.corePoolSize());
            this.maxPoolSize(builder.maxPoolSize());
            this.keepAlive(builder.keepAlive());
            this.queueCapacity(builder.queueCapacity());
            this.daemon(builder.daemon());
            builder.name().ifPresent(this::name);
            this.growthThreshold(builder.growthThreshold());
            this.growthRate(builder.growthRate());
            this.rejectionHandler(builder.rejectionHandler());
            builder.threadNamePrefix().ifPresent(this::threadNamePrefix);
            this.shouldPrestart(builder.shouldPrestart());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("virtual-threads").as(Boolean.class).ifPresent(this::virtualThreads);
            config.get("core-pool-size").as(Integer.class).ifPresent(this::corePoolSize);
            config.get("max-pool-size").as(Integer.class).ifPresent(this::maxPoolSize);
            config.get("keep-alive").as(Duration.class).ifPresent(this::keepAlive);
            config.get("queue-capacity").as(Integer.class).ifPresent(this::queueCapacity);
            config.get("is-daemon").as(Boolean.class).ifPresent(this::daemon);
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("growth-threshold").as(Integer.class).ifPresent(this::growthThreshold);
            config.get("growth-rate").as(Integer.class).ifPresent(this::growthRate);
            config.get("thread-name-prefix").as(String.class).ifPresent(this::threadNamePrefix);
            config.get("should-prestart").as(Boolean.class).ifPresent(this::shouldPrestart);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER virtualThreads(boolean virtualThreads) {
            this.virtualThreads = virtualThreads;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER corePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER keepAlive(Duration keepAlive) {
            Objects.requireNonNull(keepAlive);
            this.keepAlive = keepAlive;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER queueCapacity(int queueCapacity) {
            this.queueCapacity = queueCapacity;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER daemon(boolean daemon) {
            this.daemon = daemon;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearName() {
            this.name = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER growthThreshold(int growthThreshold) {
            this.growthThreshold = growthThreshold;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER growthRate(int growthRate) {
            this.growthRate = growthRate;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER rejectionHandler(ThreadPool.RejectionHandler rejectionHandler) {
            Objects.requireNonNull(rejectionHandler);
            this.rejectionHandler = rejectionHandler;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearThreadNamePrefix() {
            this.threadNamePrefix = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER threadNamePrefix(String threadNamePrefix) {
            Objects.requireNonNull(threadNamePrefix);
            this.threadNamePrefix = threadNamePrefix;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER shouldPrestart(boolean shouldPrestart) {
            this.shouldPrestart = shouldPrestart;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean virtualThreads() {
            return this.virtualThreads;
        }

        public int corePoolSize() {
            return this.corePoolSize;
        }

        public int maxPoolSize() {
            return this.maxPoolSize;
        }

        public Duration keepAlive() {
            return this.keepAlive;
        }

        public int queueCapacity() {
            return this.queueCapacity;
        }

        public boolean daemon() {
            return this.daemon;
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public int growthThreshold() {
            return this.growthThreshold;
        }

        public int growthRate() {
            return this.growthRate;
        }

        public ThreadPool.RejectionHandler rejectionHandler() {
            return this.rejectionHandler;
        }

        public Optional<String> threadNamePrefix() {
            return Optional.ofNullable(this.threadNamePrefix);
        }

        public boolean shouldPrestart() {
            return this.shouldPrestart;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ThreadPoolConfigBuilder{virtualThreads=" + this.virtualThreads + ",corePoolSize=" + this.corePoolSize + ",maxPoolSize=" + this.maxPoolSize + ",keepAlive=" + String.valueOf(this.keepAlive) + ",queueCapacity=" + this.queueCapacity + ",daemon=" + this.daemon + ",name=" + this.name + ",growthThreshold=" + this.growthThreshold + ",growthRate=" + this.growthRate + ",rejectionHandler=" + String.valueOf(this.rejectionHandler) + ",threadNamePrefix=" + this.threadNamePrefix + ",shouldPrestart=" + this.shouldPrestart + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        BUILDER name(Optional<String> name) {
            Objects.requireNonNull(name);
            this.name = name.map(String.class::cast).orElse(this.name);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER threadNamePrefix(Optional<String> threadNamePrefix) {
            Objects.requireNonNull(threadNamePrefix);
            this.threadNamePrefix = threadNamePrefix.map(String.class::cast).orElse(this.threadNamePrefix);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ThreadPoolConfigImpl
        implements ThreadPoolConfig,
        Supplier<ThreadPoolSupplier> {
            private final boolean daemon;
            private final boolean shouldPrestart;
            private final boolean virtualThreads;
            private final Duration keepAlive;
            private final int corePoolSize;
            private final int growthRate;
            private final int growthThreshold;
            private final int maxPoolSize;
            private final int queueCapacity;
            private final Optional<String> name;
            private final Optional<String> threadNamePrefix;
            private final ThreadPool.RejectionHandler rejectionHandler;

            protected ThreadPoolConfigImpl(BuilderBase<?, ?> builder) {
                this.virtualThreads = builder.virtualThreads();
                this.corePoolSize = builder.corePoolSize();
                this.maxPoolSize = builder.maxPoolSize();
                this.keepAlive = builder.keepAlive();
                this.queueCapacity = builder.queueCapacity();
                this.daemon = builder.daemon();
                this.name = builder.name();
                this.growthThreshold = builder.growthThreshold();
                this.growthRate = builder.growthRate();
                this.rejectionHandler = builder.rejectionHandler();
                this.threadNamePrefix = builder.threadNamePrefix();
                this.shouldPrestart = builder.shouldPrestart();
            }

            public ThreadPoolSupplier build() {
                return ThreadPoolSupplier.create(this);
            }

            @Override
            public ThreadPoolSupplier get() {
                return this.build();
            }

            @Override
            public boolean virtualThreads() {
                return this.virtualThreads;
            }

            @Override
            public int corePoolSize() {
                return this.corePoolSize;
            }

            @Override
            public int maxPoolSize() {
                return this.maxPoolSize;
            }

            @Override
            public Duration keepAlive() {
                return this.keepAlive;
            }

            @Override
            public int queueCapacity() {
                return this.queueCapacity;
            }

            @Override
            public boolean daemon() {
                return this.daemon;
            }

            @Override
            public Optional<String> name() {
                return this.name;
            }

            @Override
            public int growthThreshold() {
                return this.growthThreshold;
            }

            @Override
            public int growthRate() {
                return this.growthRate;
            }

            @Override
            public ThreadPool.RejectionHandler rejectionHandler() {
                return this.rejectionHandler;
            }

            @Override
            public Optional<String> threadNamePrefix() {
                return this.threadNamePrefix;
            }

            @Override
            public boolean shouldPrestart() {
                return this.shouldPrestart;
            }

            public String toString() {
                return "ThreadPoolConfig{virtualThreads=" + this.virtualThreads + ",corePoolSize=" + this.corePoolSize + ",maxPoolSize=" + this.maxPoolSize + ",keepAlive=" + String.valueOf(this.keepAlive) + ",queueCapacity=" + this.queueCapacity + ",daemon=" + this.daemon + ",name=" + String.valueOf(this.name) + ",growthThreshold=" + this.growthThreshold + ",growthRate=" + this.growthRate + ",rejectionHandler=" + String.valueOf(this.rejectionHandler) + ",threadNamePrefix=" + String.valueOf(this.threadNamePrefix) + ",shouldPrestart=" + this.shouldPrestart + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ThreadPoolConfig)) {
                    return false;
                }
                ThreadPoolConfig other = (ThreadPoolConfig)o;
                return this.virtualThreads == other.virtualThreads() && this.corePoolSize == other.corePoolSize() && this.maxPoolSize == other.maxPoolSize() && Objects.equals(this.keepAlive, other.keepAlive()) && this.queueCapacity == other.queueCapacity() && this.daemon == other.daemon() && Objects.equals(this.name, other.name()) && this.growthThreshold == other.growthThreshold() && this.growthRate == other.growthRate() && Objects.equals(this.rejectionHandler, other.rejectionHandler()) && Objects.equals(this.threadNamePrefix, other.threadNamePrefix()) && this.shouldPrestart == other.shouldPrestart();
            }

            public int hashCode() {
                return Objects.hash(this.virtualThreads, this.corePoolSize, this.maxPoolSize, this.keepAlive, this.queueCapacity, this.daemon, this.name, this.growthThreshold, this.growthRate, this.rejectionHandler, this.threadNamePrefix, this.shouldPrestart);
            }
        }
    }
}

