/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public abstract class AbstractCustomCreateOperation
extends AbstractOperation {
    private static final int MAX_STACK_DEPTH = 1024;
    private static final Operation.OperationResult INVALID_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INVALID_OPERATION);
    private static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    private final CodeFactory codeFactory;

    protected AbstractCustomCreateOperation(int opcode, @NonNull String name, int stackItemsConsumed, int stackItemsProduced, @NonNull GasCalculator gasCalculator, @NonNull CodeFactory codeFactory) {
        super(opcode, name, stackItemsConsumed, stackItemsProduced, gasCalculator);
        this.codeFactory = codeFactory;
    }

    protected abstract boolean isEnabled(@NonNull MessageFrame var1);

    protected abstract long cost(@NonNull MessageFrame var1);

    @Nullable
    protected abstract Address setupPendingCreation(@NonNull MessageFrame var1);

    protected abstract void onSuccess(@NonNull MessageFrame var1, @NonNull Address var2);

    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        if (FrameUtils.isHookExecution(frame)) {
            return new Operation.OperationResult(0L, ExceptionalHaltReason.INVALID_OPERATION);
        }
        if (!this.isEnabled(frame)) {
            return INVALID_RESPONSE;
        }
        if (frame.stackSize() < this.getStackItemsConsumed()) {
            return UNDERFLOW_RESPONSE;
        }
        long cost = this.cost(frame);
        if (frame.isStatic()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Wei value = Wei.wrap((Bytes)frame.getStackItem(0));
        MutableAccount account = frame.getWorldUpdater().getAccount(frame.getRecipientAddress());
        frame.clearReturnData();
        if (value.compareTo((Bytes)account.getBalance()) > 0 || frame.getDepth() >= 1024) {
            this.fail(frame);
        } else {
            this.spawnChildMessage(frame);
        }
        return new Operation.OperationResult(cost, null);
    }

    private void spawnChildMessage(@NonNull MessageFrame frame) {
        long cost = this.cost(frame);
        frame.decrementRemainingGas(cost);
        MutableAccount account = frame.getWorldUpdater().getAccount(frame.getRecipientAddress());
        account.incrementNonce();
        Wei value = Wei.wrap((Bytes)frame.getStackItem(0));
        long inputOffset = Words.clampedToLong((Bytes)frame.getStackItem(1));
        long inputSize = Words.clampedToLong((Bytes)frame.getStackItem(2));
        Bytes inputData = frame.readMemory(inputOffset, inputSize);
        Address contractAddress = this.setupPendingCreation(frame);
        if (contractAddress == null) {
            this.fail(frame);
            return;
        }
        long childGasStipend = this.gasCalculator().gasAvailableForChildCreate(frame.getRemainingGas());
        frame.decrementRemainingGas(childGasStipend);
        MessageFrame.builder().parentMessageFrame(frame).type(MessageFrame.Type.CONTRACT_CREATION).initialGas(childGasStipend).address(contractAddress).contract(contractAddress).inputData(Bytes.EMPTY).sender(frame.getRecipientAddress()).value(value).apparentValue(value).code(this.codeFactory.createCode(inputData, false)).completer(child -> this.complete(frame, (MessageFrame)child)).build();
        frame.incrementRemainingGas(cost);
        frame.setState(MessageFrame.State.CODE_SUSPENDED);
    }

    private void fail(@NonNull MessageFrame frame) {
        long inputOffset = Words.clampedToLong((Bytes)frame.getStackItem(1));
        long inputSize = Words.clampedToLong((Bytes)frame.getStackItem(2));
        frame.readMutableMemory(inputOffset, inputSize);
        frame.popStackItems(this.getStackItemsConsumed());
        frame.pushStackItem((Bytes)UInt256.ZERO);
    }

    private void complete(@NonNull MessageFrame frame, @NonNull MessageFrame childFrame) {
        frame.setState(MessageFrame.State.CODE_EXECUTING);
        frame.incrementRemainingGas(childFrame.getRemainingGas());
        frame.addLogs(childFrame.getLogs());
        frame.addCreates(childFrame.getCreates());
        frame.addSelfDestructs(childFrame.getSelfDestructs());
        frame.incrementGasRefund(childFrame.getGasRefund());
        frame.popStackItems(this.getStackItemsConsumed());
        if (childFrame.getState() == MessageFrame.State.COMPLETED_SUCCESS) {
            Address creation = childFrame.getContractAddress();
            frame.pushStackItem((Bytes)Words.fromAddress((Address)creation));
            this.onSuccess(frame, creation);
        } else {
            frame.setReturnData(childFrame.getOutputData());
            frame.pushStackItem((Bytes)UInt256.ZERO);
        }
        int currentPC = frame.getPC();
        frame.setPC(currentPC + 1);
    }
}

