/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.http.http2.Http2ErrorCode;
import io.helidon.http.http2.Http2Exception;
import io.helidon.http.http2.Http2FrameType;

public enum Http2StreamState {
    IDLE,
    RESERVED_LOCAL,
    RESERVED_REMOTE,
    OPEN,
    HALF_CLOSED_LOCAL,
    HALF_CLOSED_REMOTE,
    CLOSED;


    public static Http2StreamState checkAndGetState(Http2StreamState current, Http2FrameType frameType, boolean send, boolean endOfStream, boolean endOfHeaders) {
        switch (frameType) {
            case DATA: {
                return Http2StreamState.checkData(current, send, endOfStream);
            }
            case HEADERS: {
                return Http2StreamState.checkHeaders(current, send, endOfStream, endOfHeaders, "headers");
            }
            case PRIORITY: {
                return Http2StreamState.checkPriority(current);
            }
            case RST_STREAM: {
                return Http2StreamState.checkRstStream(current, send);
            }
            case SETTINGS: {
                return Http2StreamState.fail(Http2FrameType.SETTINGS, send);
            }
            case PUSH_PROMISE: {
                return Http2StreamState.checkPushPromise(current, send);
            }
            case PING: {
                return Http2StreamState.fail(Http2FrameType.PING, send);
            }
            case GO_AWAY: {
                return Http2StreamState.fail(Http2FrameType.GO_AWAY, send);
            }
            case WINDOW_UPDATE: {
                return Http2StreamState.checkWindowUpdate(current, send);
            }
            case CONTINUATION: {
                return Http2StreamState.checkHeaders(current, send, endOfHeaders, endOfStream, "continuation");
            }
        }
        throw new Http2Exception(Http2ErrorCode.INTERNAL, "Invalid stream state (unknown)");
    }

    private static Http2StreamState checkWindowUpdate(Http2StreamState current, boolean send) {
        return current;
    }

    private static Http2StreamState fail(Http2FrameType frameType, boolean send) {
        if (send) {
            throw new Http2Exception(Http2ErrorCode.INTERNAL, "Attempting to send " + String.valueOf((Object)frameType) + " frame on a stream");
        }
        throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received " + String.valueOf((Object)frameType) + " on a stream");
    }

    private static Http2StreamState checkPriority(Http2StreamState current) {
        return current;
    }

    private static Http2StreamState checkPushPromise(Http2StreamState current, boolean send) {
        if (current == IDLE) {
            return send ? RESERVED_LOCAL : RESERVED_REMOTE;
        }
        if (send) {
            throw new Http2Exception(Http2ErrorCode.INTERNAL, "Attempting to send push promise in invalid state: " + String.valueOf((Object)current));
        }
        throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received push promise in invalid state: " + String.valueOf((Object)current));
    }

    private static Http2StreamState checkRstStream(Http2StreamState current, boolean send) {
        if (current == IDLE) {
            if (send) {
                throw new Http2Exception(Http2ErrorCode.INTERNAL, "Attempting to send RST_STREAM in invalid state: " + String.valueOf((Object)current));
            }
            throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received RST_STREAM in invalid state: " + String.valueOf((Object)current));
        }
        return CLOSED;
    }

    private static Http2StreamState checkHeaders(Http2StreamState current, boolean send, boolean endOfStream, boolean endOfHeaders, String type) {
        if (send) {
            if (current == IDLE) {
                if (endOfHeaders) {
                    return endOfStream ? HALF_CLOSED_LOCAL : OPEN;
                }
                return current;
            }
            if (current == RESERVED_LOCAL) {
                if (endOfHeaders) {
                    return HALF_CLOSED_REMOTE;
                }
                return current;
            }
            throw new Http2Exception(Http2ErrorCode.INTERNAL, "Attempting to send " + type + " in invalid state: " + String.valueOf((Object)current));
        }
        if (current == IDLE) {
            if (endOfHeaders) {
                return endOfStream ? HALF_CLOSED_REMOTE : OPEN;
            }
            return current;
        }
        if (current == RESERVED_REMOTE) {
            if (endOfHeaders) {
                return HALF_CLOSED_LOCAL;
            }
            return current;
        }
        if (current == HALF_CLOSED_LOCAL) {
            return HALF_CLOSED_LOCAL;
        }
        if (current == OPEN) {
            return endOfStream ? HALF_CLOSED_REMOTE : OPEN;
        }
        throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received " + type + " in invalid state: " + String.valueOf((Object)current));
    }

    private static Http2StreamState checkData(Http2StreamState current, boolean send, boolean endOfStream) {
        if (send) {
            if (current == OPEN) {
                return endOfStream ? HALF_CLOSED_LOCAL : current;
            }
            if (current == HALF_CLOSED_REMOTE) {
                return endOfStream ? CLOSED : current;
            }
            throw new Http2Exception(Http2ErrorCode.INTERNAL, "Attempting to send data frame in invalid state: " + String.valueOf((Object)current));
        }
        if (current == OPEN) {
            return endOfStream ? HALF_CLOSED_REMOTE : current;
        }
        if (current == HALF_CLOSED_LOCAL) {
            return endOfStream ? CLOSED : current;
        }
        throw new Http2Exception(Http2ErrorCode.PROTOCOL, "Received data frame in invalid state: " + String.valueOf((Object)current));
    }
}

