/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.service.contract.impl.state.RentFactors;
import com.hedera.node.app.service.contract.impl.state.TxStorageUsage;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;

public interface EvmFrameState {
    public long numBytecodesInState();

    public Optional<ExceptionalHaltReason> tryTransfer(@NonNull Address var1, @NonNull Address var2, long var3, boolean var5);

    public Optional<ExceptionalHaltReason> tryLazyCreation(@NonNull Address var1);

    public boolean isHollowAccount(@NonNull Address var1);

    public void finalizeHollowAccount(@NonNull Address var1);

    public Optional<ExceptionalHaltReason> tryTrackingSelfDestructBeneficiary(@NonNull Address var1, @NonNull Address var2, @NonNull MessageFrame var3);

    public void trackSelfDestructBeneficiary(@NonNull Address var1, @NonNull Address var2, @NonNull MessageFrame var3);

    @Nullable
    public Account getAccount(Address var1);

    @Nullable
    public MutableAccount getMutableAccount(Address var1);

    @NonNull
    public UInt256 getStorageValue(ContractID var1, @NonNull UInt256 var2);

    public void setStorageValue(ContractID var1, @NonNull UInt256 var2, @NonNull UInt256 var3);

    @NonNull
    public UInt256 getOriginalStorageValue(ContractID var1, @NonNull UInt256 var2);

    @NonNull
    public Bytes getCode(ContractID var1);

    public void setCode(ContractID var1, @NonNull Bytes var2);

    @NonNull
    public Bytes getTokenRedirectCode(@NonNull Address var1);

    @NonNull
    public Hash getCodeHash(ContractID var1, @NonNull CodeFactory var2);

    @NonNull
    public Hash getTokenRedirectCodeHash(@NonNull Address var1);

    @NonNull
    public Bytes getAccountRedirectCode(@Nullable Address var1);

    @NonNull
    public Hash getAccountRedirectCodeHash(@Nullable Address var1);

    @NonNull
    public Bytes getScheduleRedirectCode(@Nullable Address var1);

    @NonNull
    public Hash getScheduleRedirectCodeHash(@Nullable Address var1);

    public com.hedera.hapi.node.state.token.Account getNativeAccount(AccountID var1);

    public long getNonce(AccountID var1);

    public int getNumTreasuryTitles(AccountID var1);

    public int getNumPositiveTokenBalances(AccountID var1);

    public boolean isContract(AccountID var1);

    public void setNonce(long var1, long var3);

    public Wei getBalance(AccountID var1);

    @Nullable
    public Address getAddress(long var1);

    @Nullable
    public Address getAddress(AccountID var1);

    public long getIdNumber(@NonNull Address var1);

    @NonNull
    public TxStorageUsage getTxStorageUsage(boolean var1);

    public long getKvStateSize();

    @NonNull
    public RentFactors getRentFactorsFor(@NonNull ContractID var1);

    @NonNull
    public RentFactors getRentFactorsFor(@NonNull AccountID var1);

    @NonNull
    public EntityIdFactory entityIdFactory();
}

