/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.service.contract.impl.state.StorageAccess;
import com.hedera.node.app.service.contract.impl.state.StorageSizeChange;
import java.util.List;

public record StorageAccesses(ContractID contractID, List<StorageAccess> accesses) {
    public StorageSizeChange summarizeSizeEffects() {
        int numRemovals = 0;
        int numInsertions = 0;
        for (StorageAccess change : this.accesses()) {
            if (change.isRemoval()) {
                ++numRemovals;
                continue;
            }
            if (!change.isInsertion()) continue;
            ++numInsertions;
        }
        return new StorageSizeChange(this.contractID, numRemovals, numInsertions);
    }
}

