/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.node.app.blocks.BlockItemWriter;
import com.hedera.node.app.blocks.impl.streaming.BlockBufferService;
import com.hedera.node.app.blocks.impl.streaming.BlockNodeConnectionManager;
import com.hedera.node.internal.network.PendingProof;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GrpcBlockItemWriter
implements BlockItemWriter {
    private static final Logger logger = LogManager.getLogger(GrpcBlockItemWriter.class);
    private final BlockBufferService blockBufferService;
    private final BlockNodeConnectionManager blockNodeConnectionManager;
    private long blockNumber;

    public GrpcBlockItemWriter(@NonNull BlockBufferService blockBufferService, @NonNull BlockNodeConnectionManager blockNodeConnectionManager) {
        this.blockBufferService = Objects.requireNonNull(blockBufferService, "blockBufferService must not be null");
        this.blockNodeConnectionManager = Objects.requireNonNull(blockNodeConnectionManager, "blockNodeConnectionManager must not be null");
    }

    @Override
    public void openBlock(long blockNumber) {
        if (blockNumber < 0L) {
            throw new IllegalArgumentException("Block number must be non-negative");
        }
        this.blockNumber = blockNumber;
        this.blockBufferService.openBlock(blockNumber);
        logger.debug("Started new block in GrpcBlockItemWriter {}", (Object)blockNumber);
    }

    @Override
    public void writePbjItem(@NonNull BlockItem blockItem) {
        Objects.requireNonNull(blockItem, "blockItem must not be null");
        this.blockBufferService.addItem(this.blockNumber, blockItem);
    }

    @Override
    public void writePbjItemAndBytes(@NonNull BlockItem item, @NonNull Bytes bytes) {
        Objects.requireNonNull(item, "item must not be null");
        Objects.requireNonNull(bytes, "bytes must not be null");
        this.writePbjItem(item);
    }

    @Override
    public void closeCompleteBlock() {
        this.blockBufferService.closeBlock(this.blockNumber);
        logger.debug("Closed block in GrpcBlockItemWriter {}", (Object)this.blockNumber);
    }

    @Override
    public void jumpToBlockAfterFreeze(long blockNumber) {
    }

    @Override
    public void flushPendingBlock(@NonNull PendingProof pendingProof) {
    }
}

