/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.grpc.impl.usage;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.grpc.MethodDescriptor;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public record RpcEndpointName(@NonNull String serviceName, @NonNull String methodName) {
    private static final String UNKNOWN = "Unknown";
    private static final ConcurrentMap<String, RpcEndpointName> rpcNameCache = new ConcurrentHashMap<String, RpcEndpointName>(100);

    public RpcEndpointName {
        Objects.requireNonNull(serviceName, "serviceName is required");
        Objects.requireNonNull(methodName, "methodName is required");
    }

    @NonNull
    public static RpcEndpointName from(@NonNull MethodDescriptor<?, ?> descriptor) {
        Objects.requireNonNull(descriptor, "descriptor is required");
        RpcEndpointName rpcEndpointName = (RpcEndpointName)rpcNameCache.get(descriptor.getFullMethodName());
        if (rpcEndpointName != null) {
            return rpcEndpointName;
        }
        String svcName = descriptor.getServiceName();
        Object methodName = descriptor.getBareMethodName();
        if (svcName == null || svcName.isBlank()) {
            svcName = UNKNOWN;
        } else if (svcName.startsWith("proto.")) {
            svcName = svcName.substring(6);
        }
        methodName = methodName == null || ((String)methodName).isBlank() ? UNKNOWN : Character.toUpperCase(((String)methodName).charAt(0)) + ((String)methodName).substring(1);
        rpcEndpointName = new RpcEndpointName(svcName, (String)methodName);
        rpcNameCache.put(descriptor.getFullMethodName(), rpcEndpointName);
        return rpcEndpointName;
    }
}

