/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.schedule.impl;

import com.hedera.node.app.hapi.fees.usage.schedule.ScheduleOpsUsage;
import com.hedera.node.app.hapi.fees.usage.schedule.ScheduleOpsUsage_Factory;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.schedule.ScheduleServiceApi;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceApiProvider;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceApiProvider_Factory;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceComponent;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceModule_ProvideScheduleHandlersFactory;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleCreateHandler;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleCreateHandler_Factory;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleDeleteHandler;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleDeleteHandler_Factory;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleFeeCharging;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleFeeCharging_Factory;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleGetInfoHandler;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleGetInfoHandler_Factory;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleHandlers;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleSignHandler;
import com.hedera.node.app.service.schedule.impl.handlers.ScheduleSignHandler_Factory;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.throttle.Throttle;
import dagger.internal.DaggerGenerated;
import dagger.internal.DoubleCheck;
import dagger.internal.InstanceFactory;
import dagger.internal.Preconditions;
import dagger.internal.Provider;
import java.time.InstantSource;
import java.util.function.Supplier;

@DaggerGenerated
public final class DaggerScheduleServiceComponent {
    private DaggerScheduleServiceComponent() {
    }

    public static ScheduleServiceComponent.Factory factory() {
        return new Factory();
    }

    private static final class Factory
    implements ScheduleServiceComponent.Factory {
        private Factory() {
        }

        @Override
        public ScheduleServiceComponent create(InstantSource instantSource, Throttle.Factory throttleFactory, EntityIdFactory entityIdFactory, Supplier<FeeCharging> baseFeeCharging) {
            Preconditions.checkNotNull((Object)instantSource);
            Preconditions.checkNotNull((Object)throttleFactory);
            Preconditions.checkNotNull((Object)entityIdFactory);
            Preconditions.checkNotNull(baseFeeCharging);
            return new ScheduleServiceComponentImpl(instantSource, throttleFactory, entityIdFactory, baseFeeCharging);
        }
    }

    private static final class ScheduleServiceComponentImpl
    implements ScheduleServiceComponent {
        private final ScheduleServiceComponentImpl scheduleServiceComponentImpl = this;
        Provider<EntityIdFactory> entityIdFactoryProvider;
        Provider<InstantSource> instantSourceProvider;
        Provider<Throttle.Factory> throttleFactoryProvider;
        Provider<Supplier<FeeCharging>> baseFeeChargingProvider;
        Provider<ScheduleFeeCharging> scheduleFeeChargingProvider;
        Provider<ScheduleCreateHandler> scheduleCreateHandlerProvider;
        Provider<ScheduleServiceApiProvider> scheduleServiceApiProvider;
        Provider<ScheduleOpsUsage> scheduleOpsUsageProvider;
        Provider<ScheduleGetInfoHandler> scheduleGetInfoHandlerProvider;
        Provider<ScheduleSignHandler> scheduleSignHandlerProvider;
        Provider<ScheduleDeleteHandler> scheduleDeleteHandlerProvider;
        Provider<ScheduleHandlers> provideScheduleHandlersProvider;

        ScheduleServiceComponentImpl(InstantSource instantSourceParam, Throttle.Factory throttleFactoryParam, EntityIdFactory entityIdFactoryParam, Supplier<FeeCharging> baseFeeChargingParam) {
            this.initialize(instantSourceParam, throttleFactoryParam, entityIdFactoryParam, baseFeeChargingParam);
        }

        private void initialize(InstantSource instantSourceParam, Throttle.Factory throttleFactoryParam, EntityIdFactory entityIdFactoryParam, Supplier<FeeCharging> baseFeeChargingParam) {
            this.entityIdFactoryProvider = InstanceFactory.create((Object)entityIdFactoryParam);
            this.instantSourceProvider = InstanceFactory.create((Object)instantSourceParam);
            this.throttleFactoryProvider = InstanceFactory.create((Object)throttleFactoryParam);
            this.baseFeeChargingProvider = InstanceFactory.create(baseFeeChargingParam);
            this.scheduleFeeChargingProvider = DoubleCheck.provider((Provider)ScheduleFeeCharging_Factory.create(this.baseFeeChargingProvider));
            this.scheduleCreateHandlerProvider = DoubleCheck.provider((Provider)ScheduleCreateHandler_Factory.create(this.entityIdFactoryProvider, this.instantSourceProvider, this.throttleFactoryProvider, this.scheduleFeeChargingProvider));
            this.scheduleServiceApiProvider = DoubleCheck.provider((Provider)ScheduleServiceApiProvider_Factory.create(this.scheduleCreateHandlerProvider));
            this.scheduleOpsUsageProvider = DoubleCheck.provider((Provider)ScheduleOpsUsage_Factory.create());
            this.scheduleGetInfoHandlerProvider = DoubleCheck.provider((Provider)ScheduleGetInfoHandler_Factory.create(this.scheduleOpsUsageProvider));
            this.scheduleSignHandlerProvider = DoubleCheck.provider((Provider)ScheduleSignHandler_Factory.create(this.scheduleFeeChargingProvider));
            this.scheduleDeleteHandlerProvider = DoubleCheck.provider((Provider)ScheduleDeleteHandler_Factory.create(this.scheduleFeeChargingProvider));
            this.provideScheduleHandlersProvider = DoubleCheck.provider((Provider)ScheduleServiceModule_ProvideScheduleHandlersFactory.create(this.scheduleCreateHandlerProvider, this.scheduleGetInfoHandlerProvider, this.scheduleSignHandlerProvider, this.scheduleDeleteHandlerProvider));
        }

        @Override
        public ServiceApiProvider<ScheduleServiceApi> scheduleServiceApiProvider() {
            return (ServiceApiProvider)this.scheduleServiceApiProvider.get();
        }

        @Override
        public ScheduleHandlers handlers() {
            return (ScheduleHandlers)this.provideScheduleHandlersProvider.get();
        }
    }
}

