/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SelfBalanceOperation
extends AbstractFixedCostOperation {
    public SelfBalanceOperation(GasCalculator gasCalculator) {
        super(71, "SELFBALANCE", 0, 1, gasCalculator, gasCalculator.getLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Address accountAddress = frame.getRecipientAddress();
        Account account = frame.getWorldUpdater().get(accountAddress);
        frame.pushStackItem((Bytes)(account == null ? Bytes.EMPTY : account.getBalance()));
        return this.successResponse;
    }
}

