/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.config.sources;

import com.hedera.hapi.node.base.Setting;
import com.swirlds.config.extensions.sources.AbstractConfigSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SettingsConfigSource
extends AbstractConfigSource {
    private final Map<String, String> properties;
    private final int ordinal;

    public SettingsConfigSource(@NonNull List<Setting> settings, int ordinal) {
        Objects.requireNonNull(settings, "settings must not be null");
        this.ordinal = ordinal;
        HashMap<String, String> mutableMap = new HashMap<String, String>();
        for (Setting setting : settings) {
            mutableMap.put(setting.name(), setting.value());
        }
        this.properties = Collections.unmodifiableMap(mutableMap);
    }

    protected Map<String, String> getInternalProperties() {
        return this.properties;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

