/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.concurrency.limits;

import io.helidon.builder.api.RuntimeType;
import io.helidon.common.concurrency.limits.AimdLimitConfig;
import io.helidon.common.concurrency.limits.AimdLimitImpl;
import io.helidon.common.concurrency.limits.Limit;
import io.helidon.common.concurrency.limits.LimitAlgorithm;
import io.helidon.common.concurrency.limits.SemaphoreLimit;
import io.helidon.common.config.Config;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Semaphore;
import java.util.function.Consumer;

@RuntimeType.PrototypedBy(value=AimdLimitConfig.class)
public class AimdLimit
implements Limit,
SemaphoreLimit,
RuntimeType.Api<AimdLimitConfig> {
    public static final int DEFAULT_QUEUE_LENGTH = 0;
    public static final String DEFAULT_QUEUE_TIMEOUT_DURATION = "PT1S";
    static final String TYPE = "aimd";
    private final AimdLimitConfig config;
    private final AimdLimitImpl aimdLimitImpl;

    private AimdLimit(AimdLimitConfig config) {
        this.config = config;
        this.aimdLimitImpl = new AimdLimitImpl(config);
    }

    public static AimdLimitConfig.Builder builder() {
        return AimdLimitConfig.builder();
    }

    public static AimdLimit create() {
        return AimdLimit.builder().build();
    }

    public static AimdLimit create(Config config) {
        return ((AimdLimitConfig.Builder)AimdLimit.builder().config(config)).build();
    }

    public static AimdLimit create(AimdLimitConfig config) {
        return new AimdLimit(config);
    }

    public static AimdLimit create(Consumer<AimdLimitConfig.Builder> consumer) {
        return ((AimdLimitConfig.Builder)AimdLimit.builder().update(consumer)).build();
    }

    @Override
    public <T> T invoke(Callable<T> callable) throws Exception {
        return this.aimdLimitImpl.invoke(callable);
    }

    @Override
    public void invoke(Runnable runnable) throws Exception {
        this.aimdLimitImpl.invoke(runnable);
    }

    @Override
    public Optional<LimitAlgorithm.Token> tryAcquire(boolean wait) {
        return this.aimdLimitImpl.tryAcquire(wait);
    }

    @Override
    public Semaphore semaphore() {
        return this.aimdLimitImpl.semaphore();
    }

    public String name() {
        return this.config.name();
    }

    public String type() {
        return TYPE;
    }

    public AimdLimitConfig prototype() {
        return this.config;
    }

    @Override
    public Limit copy() {
        return (Limit)this.config.build();
    }

    @Override
    public void init(String socketName) {
        this.aimdLimitImpl.initMetrics(socketName, this.config);
    }
}

