/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class DupOperation
extends AbstractFixedCostOperation {
    public static final int DUP_BASE = 127;
    static final Operation.OperationResult dupSuccess = new Operation.OperationResult(3L, null);
    protected final Operation.OperationResult underflowResponse;
    private final int index;

    public DupOperation(int index, GasCalculator gasCalculator) {
        super(128 + index - 1, "DUP" + index, index, index + 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
        this.index = index;
        this.underflowResponse = new Operation.OperationResult(this.gasCost, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return DupOperation.staticOperation(frame, this.index);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame, int index) {
        frame.pushStackItem(frame.getStackItem(index - 1));
        return dupSuccess;
    }
}

