/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.roster.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.stream.Stream;

public record RosterTransitionWeights(@NonNull SortedMap<Long, Long> sourceNodeWeights, @NonNull SortedMap<Long, Long> targetNodeWeights, long sourceWeightThreshold, long targetWeightThreshold) {
    public RosterTransitionWeights(@NonNull SortedMap<Long, Long> sourceNodeWeights, @NonNull SortedMap<Long, Long> targetNodeWeights) {
        this(Objects.requireNonNull(sourceNodeWeights), Objects.requireNonNull(targetNodeWeights), RosterTransitionWeights.atLeastOneThirdOfTotal(sourceNodeWeights), RosterTransitionWeights.moreThanTwoThirdsOfTotal(targetNodeWeights));
    }

    public Set<Long> sourceNodeIds() {
        return this.sourceNodeWeights.keySet();
    }

    public Set<Long> targetNodeIds() {
        return this.targetNodeWeights.keySet();
    }

    public boolean sourceNodesHaveTargetThreshold() {
        return this.sourceNodeWeights.keySet().stream().filter(this.targetNodeWeights::containsKey).mapToLong(this.targetNodeWeights::get).sum() >= this.targetWeightThreshold;
    }

    public Stream<NodeWeight> orderedSourceWeights() {
        return this.sourceNodeWeights.entrySet().stream().map(entry -> new NodeWeight((Long)entry.getKey(), (Long)entry.getValue())).sorted();
    }

    public Stream<NodeWeight> orderedTargetWeights() {
        return this.targetNodeWeights.entrySet().stream().map(entry -> new NodeWeight((Long)entry.getKey(), (Long)entry.getValue())).sorted();
    }

    public long sourceWeightOf(long nodeId) {
        return this.sourceNodeWeights.getOrDefault(nodeId, 0L);
    }

    public long totalSourceWeight() {
        return this.sourceNodeWeights.values().stream().mapToLong(Long::longValue).sum();
    }

    public boolean targetIncludes(long nodeId) {
        return this.targetNodeWeights.containsKey(nodeId);
    }

    public long targetWeightOf(long nodeId) {
        return this.targetNodeWeights.getOrDefault(nodeId, 0L);
    }

    public int targetRosterSize() {
        return this.targetNodeWeights.size();
    }

    public int numTargetNodesInSource() {
        return this.numTargetNodesIn(this.sourceNodeWeights.keySet());
    }

    public int numTargetNodesIn(@NonNull Set<Long> nodeIds) {
        return this.targetNodeWeights.keySet().stream().filter(nodeIds::contains).mapToInt(i -> 1).sum();
    }

    public static long atLeastOneThirdOfTotal(@NonNull Map<Long, Long> weights) {
        Objects.requireNonNull(weights);
        return RosterTransitionWeights.atLeastOneThirdOfTotal(weights.values().stream().mapToLong(Long::longValue).sum());
    }

    public static long atLeastOneThirdOfTotal(long totalWeight) {
        return (totalWeight + 2L) / 3L;
    }

    public static long moreThanTwoThirdsOfTotal(@NonNull Map<Long, Long> weights) {
        Objects.requireNonNull(weights);
        return RosterTransitionWeights.moreThanTwoThirdsOfTotal(weights.values().stream().mapToLong(Long::longValue).sum());
    }

    public static long moreThanTwoThirdsOfTotal(long totalWeight) {
        return BigInteger.valueOf(totalWeight).multiply(BigInteger.TWO).divide(BigInteger.valueOf(3L)).add(BigInteger.ONE).longValueExact();
    }

    public record NodeWeight(long nodeId, long weight) implements Comparable<NodeWeight>
    {
        private static final Comparator<NodeWeight> NODE_ID_COMPARATOR = Comparator.comparingLong(NodeWeight::nodeId);

        @Override
        public int compareTo(@NonNull NodeWeight that) {
            return NODE_ID_COMPARATOR.compare(this, that);
        }
    }
}

