/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webclient.http1;

import io.helidon.http.ClientResponseHeaders;
import io.helidon.http.ClientResponseTrailers;
import io.helidon.http.Status;
import io.helidon.http.media.ReadableEntity;
import io.helidon.webclient.api.ClientConnection;
import io.helidon.webclient.api.ClientUri;
import io.helidon.webclient.api.HttpClientResponse;
import java.util.NoSuchElementException;

public final class UpgradeResponse {
    private final boolean isUpgraded;
    private final ClientConnection connection;
    private final HttpClientResponse response;

    private UpgradeResponse(boolean isUpgraded, ClientConnection connection, HttpClientResponse response) {
        this.isUpgraded = isUpgraded;
        this.connection = connection;
        this.response = response;
    }

    public static UpgradeResponse success(HttpClientResponse response, ClientConnection connection) {
        return new UpgradeResponse(true, connection, new NoCloseResponse(response));
    }

    public static UpgradeResponse failure(HttpClientResponse response) {
        return new UpgradeResponse(false, null, response);
    }

    public String toString() {
        return String.valueOf(this.response.status()) + ": " + String.valueOf(this.response.headers());
    }

    public boolean isUpgraded() {
        return this.isUpgraded;
    }

    public ClientConnection connection() {
        if (this.connection == null) {
            throw new NoSuchElementException("If upgrade fails, connection cannot be obtained");
        }
        return this.connection;
    }

    public HttpClientResponse response() {
        return this.response;
    }

    private static class NoCloseResponse
    implements HttpClientResponse {
        private final HttpClientResponse delegate;

        NoCloseResponse(HttpClientResponse response) {
            this.delegate = response;
        }

        public Status status() {
            return this.delegate.status();
        }

        public ClientResponseHeaders headers() {
            return this.delegate.headers();
        }

        public ClientResponseTrailers trailers() {
            return this.delegate.trailers();
        }

        public ClientUri lastEndpointUri() {
            return this.delegate.lastEndpointUri();
        }

        public ReadableEntity entity() {
            return this.delegate.entity();
        }

        public void close() {
        }
    }
}

