/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.StatsConfig;
import com.swirlds.common.metrics.IntegerPairAccumulator;
import com.swirlds.common.metrics.RunningAverageMetric;
import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.IntegerAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BinaryOperator;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class OpWorkflowMetrics {
    private static final BinaryOperator<Integer> AVERAGE = (sum, count) -> count == 0 ? 0 : sum / count;
    private static final RunningAverageMetric.Config GAS_PER_CONS_SEC_CONFIG = new RunningAverageMetric.Config("app", "gasPerConsSec").withDescription("average EVM gas used per second of consensus time").withFormat("%,13.6f");
    private final Map<HederaFunctionality, TransactionMetric> transactionDurationMetrics = new EnumMap<HederaFunctionality, TransactionMetric>(HederaFunctionality.class);
    private final Map<HederaFunctionality, Counter> transactionThrottleMetrics = new EnumMap<HederaFunctionality, Counter>(HederaFunctionality.class);
    private final RunningAverageMetric gasPerConsSec;
    private long gasUsedThisConsensusSecond = 0L;

    @Inject
    public OpWorkflowMetrics(@NonNull Metrics metrics, @NonNull ConfigProvider configProvider) {
        Objects.requireNonNull(metrics, "metrics must not be null");
        Objects.requireNonNull(configProvider, "configProvider must not be null");
        for (HederaFunctionality functionality : HederaFunctionality.values()) {
            if (functionality == HederaFunctionality.NONE) continue;
            String protoName = functionality.protoName();
            String name = protoName.substring(0, 1).toLowerCase() + protoName.substring(1);
            IntegerAccumulator.Config maxConfig = new IntegerAccumulator.Config("app", name + "DurationMax").withDescription("The maximum duration of a " + name + " transaction in nanoseconds").withUnit("ns");
            IntegerAccumulator maxMetric = (IntegerAccumulator)metrics.getOrCreate((MetricConfig)maxConfig);
            IntegerPairAccumulator.Config avgConfig = new IntegerPairAccumulator.Config("app", name + "DurationAvg", Integer.class, AVERAGE).withDescription("The average duration of a " + name + " transaction in nanoseconds").withUnit("ns");
            IntegerPairAccumulator avgMetric = (IntegerPairAccumulator)metrics.getOrCreate((MetricConfig)avgConfig);
            this.transactionDurationMetrics.put(functionality, new TransactionMetric(maxMetric, (IntegerPairAccumulator<Integer>)avgMetric));
            Counter.Config throttledConfig = new Counter.Config("app", name + "ThrottledTxns").withDescription("The number of " + name + " transactions that were rejected due to throttle limits");
            this.transactionThrottleMetrics.put(functionality, (Counter)metrics.getOrCreate((MetricConfig)throttledConfig));
        }
        StatsConfig statsConfig = (StatsConfig)configProvider.getConfiguration().getConfigData(StatsConfig.class);
        this.gasPerConsSec = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)GAS_PER_CONS_SEC_CONFIG.withHalfLife(statsConfig.runningAvgHalfLifeSecs()));
    }

    public void updateDuration(@NonNull HederaFunctionality functionality, int duration) {
        Objects.requireNonNull(functionality, "functionality must not be null");
        if (functionality == HederaFunctionality.NONE) {
            return;
        }
        TransactionMetric metric = this.transactionDurationMetrics.get(functionality);
        if (metric != null) {
            metric.max.update(duration);
            metric.avg.update(duration, 1);
        }
    }

    public void incrementThrottled(@NonNull HederaFunctionality functionality) {
        Objects.requireNonNull(functionality, "functionality must not be null");
        if (functionality == HederaFunctionality.NONE) {
            return;
        }
        Counter metric = this.transactionThrottleMetrics.get(functionality);
        if (metric != null) {
            metric.increment();
        }
    }

    public void switchConsensusSecond() {
        this.gasPerConsSec.update((double)this.gasUsedThisConsensusSecond);
        this.gasUsedThisConsensusSecond = 0L;
    }

    public void addGasUsed(long gasUsed) {
        this.gasUsedThisConsensusSecond += gasUsed;
    }

    private record TransactionMetric(IntegerAccumulator max, IntegerPairAccumulator<Integer> avg) {
    }
}

