/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.stack;

import com.hedera.node.app.workflows.handle.stack.WritableStatesStack;
import com.swirlds.state.spi.WritableKVState;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public class WritableKVStateStack<K, V>
implements WritableKVState<K, V> {
    private final WritableStatesStack writableStatesStack;
    private final int stateId;

    public WritableKVStateStack(@NonNull WritableStatesStack writableStatesStack, int stateId) {
        this.writableStatesStack = Objects.requireNonNull(writableStatesStack, "writableStatesStack must not be null");
        this.stateId = stateId;
    }

    @NonNull
    private WritableKVState<K, V> getCurrent() {
        return this.writableStatesStack.getCurrent().get(this.stateId);
    }

    public int getStateId() {
        return this.stateId;
    }

    @Nullable
    public V get(@NonNull K key) {
        return (V)this.getCurrent().get(key);
    }

    @Nullable
    public V getOriginalValue(@NonNull K key) {
        return (V)this.writableStatesStack.getRoot().get(this.stateId).get(key);
    }

    public void put(@NonNull K key, @NonNull V value) {
        this.getCurrent().put(key, value);
    }

    public void remove(@NonNull K key) {
        this.getCurrent().remove(key);
    }

    @NonNull
    public Iterator<K> keys() {
        return this.getCurrent().keys();
    }

    @NonNull
    public Set<K> modifiedKeys() {
        return this.getCurrent().modifiedKeys();
    }

    @NonNull
    public Set<K> readKeys() {
        return this.getCurrent().readKeys();
    }

    @Deprecated
    public long size() {
        return this.getCurrent().size();
    }
}

