/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.utils;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.CallOperationType;
import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.OpcodeUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.charset.StandardCharsets;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class ActionsHelper {
    private static final com.hedera.pbj.runtime.io.buffer.Bytes MISSING_ADDRESS_ERROR = com.hedera.pbj.runtime.io.buffer.Bytes.wrap((byte[])"INVALID_SOLIDITY_ADDRESS".getBytes(StandardCharsets.UTF_8));

    public ContractAction createSynthActionForMissingAddressIn(@NonNull MessageFrame frame, @NonNull Address targetAddress) {
        return ContractAction.newBuilder().callType(ContractActionType.CALL).gas(frame.getRemainingGas()).callDepth(frame.getDepth() + 1).callingContract(this.contractIdWith(frame, ConversionUtils.hederaIdNumOfContractIn(frame))).targetedAddress(ConversionUtils.tuweniToPbjBytes((Bytes)targetAddress)).error(MISSING_ADDRESS_ERROR).callOperationType(OpcodeUtils.asCallOperationType(frame.getCurrentOperation().getOpcode())).build();
    }

    public boolean isValid(@NonNull ContractAction action) {
        boolean ok = true;
        ok &= null != action.callType() && ContractActionType.NO_ACTION != action.callType();
        ok &= 1 == ActionsHelper.countNonNulls(action.callingAccount(), action.callingContract());
        ok &= action.input().length() > 0L;
        ok &= 1 >= ActionsHelper.countNonNulls(action.recipientAccount(), action.recipientContract(), action.targetedAddress());
        ok &= 1 == ActionsHelper.countNonNulls(action.output(), action.revertReason(), action.error());
        return ok &= null != action.callOperationType() && CallOperationType.OP_UNKNOWN != action.callOperationType();
    }

    public String prettyPrint(@NonNull ContractAction action) {
        StringBuilder sb = new StringBuilder();
        Function<Object, String> fobj = o -> null != o ? o.toString() : "<null>";
        Function<byte[], String> fbytes = b -> null != b ? (0 != ((byte[])b).length ? Bytes.wrap((byte[])b).toHexString() : "<empty>") : "<null>";
        BiConsumer<String, Object> ff = (n, o) -> {
            Object r;
            Object[] objectArray = new Object[2];
            objectArray[0] = n;
            if (o instanceof byte[]) {
                byte[] b = (byte[])o;
                r = fbytes.apply(b);
            } else {
                r = fobj.apply(o);
            }
            objectArray[1] = r;
            sb.append("%s: %s, ".formatted(objectArray));
        };
        sb.append("SolidityAction(");
        ff.accept("callType", action.callType());
        ff.accept("callOperationType", action.callOperationType());
        ff.accept("value", action.value());
        ff.accept("gas", action.gas());
        ff.accept("gasUsed", action.gasUsed());
        ff.accept("callDepth", action.callDepth());
        ff.accept("callingAccount", action.callingAccount());
        ff.accept("callingContract", action.callingContract());
        ff.accept("recipientAccount", action.recipientAccount());
        ff.accept("recipientContract", action.recipientContract());
        ff.accept("invalidSolidityAddress (aka targetedAddress)", action.targetedAddress());
        ff.accept("input", action.input());
        ff.accept("output", action.output());
        ff.accept("revertReason", action.revertReason());
        ff.accept("error", action.error());
        sb.setLength(sb.length() - 2);
        sb.append(")");
        return sb.toString();
    }

    private ContractID contractIdWith(@NonNull MessageFrame frame, long num) {
        return FrameUtils.entityIdFactory(frame).newContractId(num);
    }

    private static int countNonNulls(Object ... objs) {
        int count = 0;
        for (Object obj : objs) {
            if (null == obj) continue;
            ++count;
        }
        return count;
    }
}

