/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http.http2;

import io.helidon.common.buffers.BufferData;
import io.helidon.http.http2.Http2Flag;
import io.helidon.http.http2.Http2FrameHeader;
import io.helidon.http.http2.Http2FrameTypes;

public record Http2FrameData(Http2FrameHeader header, BufferData data) {
    public Http2FrameData[] split(int size) {
        int length = this.header().length();
        if (length <= size || length == 0) {
            return new Http2FrameData[]{this};
        }
        if (size == 0) {
            return new Http2FrameData[0];
        }
        boolean endOfStream = this.header().flags(Http2FrameTypes.DATA).endOfStream();
        int lastFrameSize = length % size;
        int allFrames = length / size + (lastFrameSize != 0 ? 1 : 0);
        Http2FrameData[] splitFrames = new Http2FrameData[allFrames];
        for (int i = 0; i < allFrames; ++i) {
            boolean lastFrame;
            boolean bl = lastFrame = allFrames == i + 1;
            byte[] data = new byte[lastFrame ? (lastFrameSize != 0 ? lastFrameSize : size) : size];
            this.data().read(data);
            BufferData bufferData = BufferData.create((byte[])data);
            splitFrames[i] = new Http2FrameData(Http2FrameHeader.create(bufferData.available(), Http2FrameTypes.DATA, Http2Flag.DataFlags.create(endOfStream && lastFrame ? 1 : 0), this.header().streamId()), bufferData);
        }
        return splitFrames;
    }

    public Http2FrameData[] cut(int size) {
        int length = this.header().length();
        if (length <= size || length == 0) {
            return new Http2FrameData[]{this};
        }
        if (size == 0) {
            return new Http2FrameData[0];
        }
        boolean endOfStream = this.header.flags(Http2FrameTypes.DATA).endOfStream();
        byte[] data1 = new byte[size];
        byte[] data2 = new byte[length - size];
        this.data().read(data1);
        this.data().read(data2);
        BufferData bufferData1 = BufferData.create((byte[])data1);
        BufferData bufferData2 = BufferData.create((byte[])data2);
        Http2FrameData frameData1 = new Http2FrameData(Http2FrameHeader.create(bufferData1.available(), Http2FrameTypes.DATA, Http2Flag.DataFlags.create(0), this.header().streamId()), bufferData1);
        Http2FrameData frameData2 = new Http2FrameData(Http2FrameHeader.create(bufferData2.available(), Http2FrameTypes.DATA, Http2Flag.DataFlags.create(endOfStream ? 1 : 0), this.header().streamId()), bufferData2);
        return new Http2FrameData[]{frameData1, frameData2};
    }
}

