/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record HydratedEthTxData(@Nullable EthTxData ethTxData, @NonNull ResponseCodeEnum status, boolean hydratedFromFile) {
    public HydratedEthTxData {
        Objects.requireNonNull(status);
        if (status == ResponseCodeEnum.OK) {
            Objects.requireNonNull(ethTxData);
        }
    }

    public static HydratedEthTxData successFrom(@NonNull EthTxData ethTxData, boolean hydratedFromFile) {
        return new HydratedEthTxData(ethTxData, ResponseCodeEnum.OK, hydratedFromFile);
    }

    public static HydratedEthTxData failureFrom(@NonNull ResponseCodeEnum status) {
        return new HydratedEthTxData(null, status, false);
    }

    public boolean isAvailable() {
        return this.ethTxData != null;
    }

    @NonNull
    public EthTxData ethTxDataOrThrow() {
        return Objects.requireNonNull(this.ethTxData);
    }
}

