/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.common.config.Config;
import io.helidon.common.configurable.ObserverManager;
import io.helidon.common.configurable.ThreadPoolConfig;
import io.helidon.common.configurable.ThreadPoolSupplier;
import java.util.concurrent.ExecutorService;
import java.util.function.Supplier;

public final class ServerThreadPoolSupplier
implements Supplier<ExecutorService> {
    private static final int MINIMUM_CORES = 2;
    private static final int DEFAULT_MIN_THREADS_PER_CORE = 2;
    private static final int DEFAULT_MAX_THREADS_PER_CORE = 8;
    private static final int DEFAULT_QUEUE_CAPACITY = 8192;
    private static final int DEFAULT_GROWTH_THRESHOLD = 256;
    private static final int DEFAULT_GROWTH_RATE = 5;
    private final ThreadPoolSupplier supplier;

    private ServerThreadPoolSupplier(ThreadPoolConfig config) {
        this.supplier = (ThreadPoolSupplier)config.build();
        ObserverManager.registerSupplier(this, "server", "helidon-");
    }

    @Override
    public ExecutorService get() {
        return ObserverManager.registerExecutorService(this, this.supplier.get());
    }

    public static ThreadPoolConfig.Builder builder() {
        int cores = Math.max(Runtime.getRuntime().availableProcessors(), 2);
        int minPoolSize = 2 * cores;
        int maxPoolSize = 8 * cores;
        return (ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)((ThreadPoolConfig.Builder)ThreadPoolSupplier.builder().corePoolSize(minPoolSize)).maxPoolSize(maxPoolSize)).queueCapacity(8192)).growthThreshold(256)).growthRate(5);
    }

    public static ThreadPoolSupplier create() {
        return ServerThreadPoolSupplier.builder().build();
    }

    public static ThreadPoolSupplier create(Config config) {
        return ((ThreadPoolConfig.Builder)ServerThreadPoolSupplier.builder().config(config)).build();
    }
}

