/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app;

import com.hedera.hapi.platform.state.QueueState;
import com.hedera.hapi.platform.state.StateValue;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.time.Time;
import com.swirlds.common.utility.Mnemonics;
import com.swirlds.config.api.Configuration;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.StateKeyUtils;
import com.swirlds.state.merkle.VirtualMapState;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualMapMetadata;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.hiero.base.constructable.ConstructableIgnored;
import org.hiero.base.crypto.Hash;
import org.json.JSONObject;

@ConstructableIgnored
public class HederaVirtualMapState
extends VirtualMapState<HederaVirtualMapState>
implements MerkleNodeState {
    public HederaVirtualMapState(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time) {
        super(configuration, metrics);
    }

    public HederaVirtualMapState(@NonNull VirtualMap virtualMap, @NonNull Metrics metrics, @NonNull Time time) {
        super(virtualMap, metrics);
    }

    protected HederaVirtualMapState(@NonNull HederaVirtualMapState from) {
        super((VirtualMapState)from);
    }

    protected HederaVirtualMapState copyingConstructor() {
        return new HederaVirtualMapState(this);
    }

    public String getInfoJson() {
        JSONObject rootJson = new JSONObject();
        RecordAccessor recordAccessor = this.virtualMap.getRecords();
        VirtualMapMetadata virtualMapMetadata = this.virtualMap.getMetadata();
        JSONObject virtualMapMetadataJson = new JSONObject();
        virtualMapMetadataJson.put("firstLeafPath", virtualMapMetadata.getFirstLeafPath());
        virtualMapMetadataJson.put("lastLeafPath", virtualMapMetadata.getLastLeafPath());
        rootJson.put("VirtualMapMetadata", (Object)virtualMapMetadataJson);
        JSONObject singletons = new JSONObject();
        JSONObject queues = new JSONObject();
        this.services.forEach((key, value) -> value.forEach((s, stateMetadata) -> {
            Bytes queueStateKey;
            VirtualLeafBytes leafBytes;
            String serviceName = stateMetadata.serviceName();
            StateDefinition stateDefinition = stateMetadata.stateDefinition();
            int stateId = stateDefinition.stateId();
            String stateKey = stateDefinition.stateKey();
            if (stateDefinition.singleton()) {
                Bytes singletonKey = StateKeyUtils.singletonKey((int)stateId);
                VirtualLeafBytes leafBytes2 = recordAccessor.findLeafRecord(singletonKey);
                if (leafBytes2 != null) {
                    Hash hash = recordAccessor.findHash(leafBytes2.path());
                    JSONObject singletonJson = new JSONObject();
                    if (hash != null) {
                        singletonJson.put("mnemonic", (Object)Mnemonics.generateMnemonic((Hash)hash));
                    }
                    singletonJson.put("path", leafBytes2.path());
                    singletons.put(StateMetadata.computeLabel((String)serviceName, (String)stateKey), (Object)singletonJson);
                }
            } else if (stateDefinition.queue() && (leafBytes = recordAccessor.findLeafRecord(queueStateKey = StateKeyUtils.queueStateKey((int)stateId))) != null) {
                try {
                    StateValue stateValue = (StateValue)StateValue.PROTOBUF.parse(leafBytes.valueBytes());
                    QueueState queueState = stateValue.queueState();
                    JSONObject queueJson = new JSONObject();
                    queueJson.put("head", queueState.head());
                    queueJson.put("tail", queueState.tail());
                    queueJson.put("path", leafBytes.path());
                    queues.put(StateMetadata.computeLabel((String)serviceName, (String)stateKey), (Object)queueJson);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        rootJson.put("Singletons", (Object)singletons);
        rootJson.put("Queues (Queue States)", (Object)queues);
        return rootJson.toString();
    }

    public String toString() {
        return "HederaVirtualMapState[round=%d]".formatted(PlatformStateFacade.DEFAULT_PLATFORM_STATE_FACADE.roundOf((State)this));
    }
}

