/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.records.impl.producers;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.blockrecords.RunningHashes;
import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.HashObject;
import com.hedera.node.app.annotations.CommonExecutor;
import com.hedera.node.app.records.impl.BlockRecordStreamProducer;
import com.hedera.node.app.records.impl.producers.BlockRecordFormat;
import com.hedera.node.app.records.impl.producers.BlockRecordWriter;
import com.hedera.node.app.records.impl.producers.BlockRecordWriterFactory;
import com.hedera.node.app.records.impl.producers.SerializedSingleTransactionRecord;
import com.hedera.node.app.state.SingleTransactionRecord;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public final class StreamFileProducerConcurrent
implements BlockRecordStreamProducer {
    private static final Logger logger = LogManager.getLogger(StreamFileProducerConcurrent.class);
    private final BlockRecordWriterFactory writerFactory;
    private final SemanticVersion hapiVersion;
    private final BlockRecordFormat format;
    private final ExecutorService executorService;
    private final Lock lock = new ReentrantLock();
    private CompletableFuture<Bytes> lastRecordHashingResult = null;
    private CompletableFuture<Bytes> lastRecordHashingResultNMinus1 = null;
    private CompletableFuture<Bytes> lastRecordHashingResultNMinus2 = null;
    private CompletableFuture<Bytes> lastRecordHashingResultNMinus3 = null;
    private CompletableFuture<BlockRecordWriter> currentRecordFileWriter = null;
    private long currentBlockNumber;

    @Inject
    public StreamFileProducerConcurrent(@NonNull BlockRecordFormat format, @NonNull BlockRecordWriterFactory writerFactory, @CommonExecutor @NonNull ExecutorService executorService, @NonNull SemanticVersion hapiVersion) {
        this.writerFactory = Objects.requireNonNull(writerFactory);
        this.format = Objects.requireNonNull(format);
        this.hapiVersion = Objects.requireNonNull(hapiVersion);
        this.executorService = Objects.requireNonNull(executorService);
    }

    @Override
    public void initRunningHash(@NonNull RunningHashes runningHashes) {
        this.lock.lock();
        try {
            if (this.lastRecordHashingResult != null) {
                throw new IllegalStateException("initRunningHash() can only be called once");
            }
            if (runningHashes.runningHash().equals((Object)Bytes.EMPTY)) {
                throw new IllegalArgumentException("The initial running hash cannot be empty");
            }
            this.lastRecordHashingResult = CompletableFuture.completedFuture(runningHashes.runningHash());
            this.lastRecordHashingResultNMinus1 = CompletableFuture.completedFuture(runningHashes.nMinus1RunningHash());
            this.lastRecordHashingResultNMinus2 = CompletableFuture.completedFuture(runningHashes.nMinus2RunningHash());
            this.lastRecordHashingResultNMinus3 = CompletableFuture.completedFuture(runningHashes.nMinus3RunningHash());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    @NonNull
    public Bytes getRunningHash() {
        assert (this.lastRecordHashingResult != null) : "initRunningHash() must be called before getRunningHash()";
        return this.lastRecordHashingResult.join();
    }

    @Override
    @Nullable
    public Bytes getNMinus3RunningHash() {
        assert (this.lastRecordHashingResultNMinus3 != null) : "initRunningHash() must be called before lastRecordHashingResultNMinus3()";
        return this.lastRecordHashingResultNMinus3.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void switchBlocks(long lastBlockNumber, long newBlockNumber, @NonNull Instant newBlockFirstTransactionConsensusTime) {
        this.lock.lock();
        try {
            assert (this.lastRecordHashingResult != null) : "initRunningHash() must be called before switchBlocks";
            if (newBlockNumber != lastBlockNumber + 1L) {
                throw new IllegalArgumentException("Block numbers must be sequential, newBlockNumber=" + newBlockNumber + ", lastBlockNumber=" + lastBlockNumber);
            }
            this.currentBlockNumber = newBlockNumber;
            Objects.requireNonNull(newBlockFirstTransactionConsensusTime);
            this.currentRecordFileWriter = this.currentRecordFileWriter == null ? this.lastRecordHashingResult.thenApply(lastRunningHash -> this.createBlockRecordWriter((Bytes)lastRunningHash, newBlockFirstTransactionConsensusTime, newBlockNumber)) : ((CompletableFuture)this.currentRecordFileWriter.thenCombine(this.lastRecordHashingResult, TwoResults::new)).thenApplyAsync(twoResults -> {
                BlockRecordWriter writer = (BlockRecordWriter)twoResults.a();
                Bytes lastRunningHash = (Bytes)twoResults.b();
                this.closeWriter(writer, lastRunningHash);
                return this.createBlockRecordWriter(lastRunningHash, newBlockFirstTransactionConsensusTime, newBlockNumber);
            }, (Executor)this.executorService);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void writeRecordStreamItems(@NonNull Stream<SingleTransactionRecord> recordStreamItems) {
        this.lock.lock();
        try {
            assert (this.lastRecordHashingResult != null) : "initRunningHash() must be called before writeRecordStreamItems";
            Objects.requireNonNull(recordStreamItems);
            CompletableFuture<List> futureSerializedRecords = CompletableFuture.supplyAsync(() -> recordStreamItems.map(item -> this.format.serialize((SingleTransactionRecord)item, this.currentBlockNumber, this.hapiVersion)).toList(), this.executorService);
            this.lastRecordHashingResultNMinus3 = this.lastRecordHashingResultNMinus2;
            this.lastRecordHashingResultNMinus2 = this.lastRecordHashingResultNMinus1;
            this.lastRecordHashingResultNMinus1 = this.lastRecordHashingResult;
            this.lastRecordHashingResult = ((CompletableFuture)this.lastRecordHashingResult.thenCombine(futureSerializedRecords, TwoResults::new)).thenApplyAsync(twoResults -> this.format.computeNewRunningHash((Bytes)twoResults.a(), (List)twoResults.b()), (Executor)this.executorService);
            if (this.currentRecordFileWriter == null) {
                return;
            }
            this.currentRecordFileWriter = ((CompletableFuture)this.currentRecordFileWriter.thenCombine(futureSerializedRecords, TwoResults::new)).thenApplyAsync(twoResults -> {
                BlockRecordWriter writer = (BlockRecordWriter)twoResults.a();
                List serializedItems = (List)twoResults.b();
                serializedItems.forEach(item -> {
                    try {
                        writer.writeItem((SerializedSingleTransactionRecord)item);
                    }
                    catch (Exception e) {
                        logger.error("Error writing record item to file", (Throwable)e);
                    }
                });
                return writer;
            }, (Executor)this.executorService);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.currentRecordFileWriter != null) {
                ((CompletableFuture)CompletableFuture.allOf(this.currentRecordFileWriter, this.lastRecordHashingResult).thenAccept(aVoid -> {
                    BlockRecordWriter writer = this.currentRecordFileWriter.join();
                    Bytes lastRunningHash = this.lastRecordHashingResult.join();
                    this.closeWriter(writer, lastRunningHash);
                })).join();
                this.lastRecordHashingResult = null;
                this.lastRecordHashingResultNMinus1 = null;
                this.lastRecordHashingResultNMinus2 = null;
                this.lastRecordHashingResultNMinus3 = null;
                this.currentRecordFileWriter = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private BlockRecordWriter createBlockRecordWriter(@NonNull Bytes lastRunningHash, @NonNull Instant startConsensusTime, long blockNumber) {
        try {
            logger.debug("Starting new block record file for block {}", (Object)blockNumber);
            BlockRecordWriter writer = this.writerFactory.create();
            HashObject startRunningHash = this.asHashObject(lastRunningHash);
            writer.init(this.hapiVersion, startRunningHash, startConsensusTime, blockNumber);
            return writer;
        }
        catch (Exception e) {
            logger.error("Error creating record file writer", (Throwable)e);
            throw e;
        }
    }

    private void closeWriter(BlockRecordWriter writer, Bytes lastRunningHash) {
        try {
            writer.close(this.asHashObject(lastRunningHash));
        }
        catch (Exception e) {
            logger.error("Error closing record file writer", (Throwable)e);
        }
    }

    private HashObject asHashObject(@NonNull Bytes hash) {
        return new HashObject(HashAlgorithm.SHA_384, (int)hash.length(), hash);
    }

    record TwoResults<A, B>(A a, B b) {
    }
}

