/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SModOperation
extends AbstractFixedCostOperation {
    private static final Operation.OperationResult smodSuccess = new Operation.OperationResult(5L, null);

    public SModOperation(GasCalculator gasCalculator) {
        super(7, "SMOD", 2, 1, gasCalculator, gasCalculator.getLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return SModOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value0 = frame.popStackItem();
        Bytes value1 = frame.popStackItem();
        if (value1.isZero()) {
            frame.pushStackItem(Bytes.EMPTY);
        } else {
            Bytes resultBytes;
            BigInteger b1 = value0.size() < 32 ? new BigInteger(1, value0.toArrayUnsafe()) : new BigInteger(value0.toArrayUnsafe());
            BigInteger b2 = value1.size() < 32 ? new BigInteger(1, value1.toArrayUnsafe()) : new BigInteger(value1.toArrayUnsafe());
            BigInteger result = b1.abs().mod(b2.abs());
            if (b1.signum() < 0) {
                result = result.negate();
            }
            if ((resultBytes = Bytes.wrap((byte[])result.toByteArray())).size() > 32) {
                resultBytes = resultBytes.slice(resultBytes.size() - 32, 32);
            }
            byte[] padding = new byte[32 - resultBytes.size()];
            Arrays.fill(padding, result.signum() < 0 ? (byte)-1 : 0);
            frame.pushStackItem(Bytes.concatenate((Bytes[])new Bytes[]{Bytes.wrap((byte[])padding), resultBytes}));
        }
        return smodSuccess;
    }
}

