/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.concurrency.limits.Limit;
import io.helidon.common.concurrency.limits.spi.LimitProvider;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigBuilderSupport;
import io.helidon.common.context.Context;
import io.helidon.common.socket.SocketOptions;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsConfig;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.http.encoding.ContentEncodingContext;
import io.helidon.http.encoding.ContentEncodingContextConfig;
import io.helidon.http.media.MediaContext;
import io.helidon.http.media.MediaContextConfig;
import io.helidon.webserver.ConnectionConfig;
import io.helidon.webserver.ErrorHandling;
import io.helidon.webserver.ListenerConfigBlueprint;
import io.helidon.webserver.Routing;
import io.helidon.webserver.WebServerConfigSupport;
import io.helidon.webserver.http.DirectHandlers;
import io.helidon.webserver.http.HttpRouting;
import io.helidon.webserver.spi.ProtocolConfig;
import io.helidon.webserver.spi.ProtocolConfigProvider;
import io.helidon.webserver.spi.ServerConnectionSelector;
import java.net.InetAddress;
import java.net.SocketOption;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.webserver.ListenerConfigBlueprint")
public interface ListenerConfig
extends ListenerConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ListenerConfig instance) {
        return (Builder)ListenerConfig.builder().from(instance);
    }

    public static ListenerConfig create(Config config) {
        return ((Builder)ListenerConfig.builder().config(config)).buildPrototype();
    }

    public static ListenerConfig create() {
        return ListenerConfig.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ListenerConfig>
    implements io.helidon.common.Builder<Builder, ListenerConfig> {
        private Builder() {
        }

        public ListenerConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ListenerConfigImpl(this);
        }

        public ListenerConfig build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ListenerConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<io.helidon.common.Builder<?, ? extends Routing>> routings = new ArrayList();
        private final List<ProtocolConfig> protocols = new ArrayList<ProtocolConfig>();
        private final List<ServerConnectionSelector> connectionSelectors = new ArrayList<ServerConnectionSelector>();
        private final Map<SocketOption<?>, Object> listenerSocketOptions = new LinkedHashMap();
        private boolean concurrencyLimitDiscoverServices = false;
        private boolean enableProxyProtocol = false;
        private boolean isConnectionSelectorsMutated;
        private boolean isProtocolsMutated;
        private boolean isRoutingsMutated;
        private boolean protocolsDiscoverServices = true;
        private boolean restoreResponseHeaders = true;
        private boolean smartAsyncWrites = false;
        private HttpRouting.Builder routing;
        private Config config;
        private ConnectionConfig connectionConfig;
        private ContentEncodingContext contentEncoding;
        private Context listenerContext;
        private DirectHandlers directHandlers;
        private Duration idleConnectionPeriod = Duration.parse("PT2M");
        private Duration idleConnectionTimeout = Duration.parse("PT5M");
        private Duration shutdownGracePeriod = Duration.parse("PT0.5S");
        private ErrorHandling errorHandling = ErrorHandling.create();
        private InetAddress address;
        private int backlog = 1024;
        private int maxConcurrentRequests = -1;
        private int maxInMemoryEntity = 131072;
        private int maxTcpConnections = -1;
        private int port = 0;
        private int writeBufferSize = 4096;
        private int writeQueueLength = 0;
        private Integer receiveBufferSize;
        private Limit concurrencyLimit;
        private long maxPayloadSize = -1L;
        private MediaContext mediaContext;
        private RequestedUriDiscoveryContext requestedUriDiscoveryContext;
        private SocketOptions connectionOptions;
        private String host = "0.0.0.0";
        private String name = "@default";
        private Tls tls;

        protected BuilderBase() {
        }

        public BUILDER from(ListenerConfig prototype) {
            if (!this.isProtocolsMutated) {
                this.protocols.clear();
            }
            this.addProtocols(prototype.protocols());
            this.protocolsDiscoverServices = false;
            this.routing(prototype.routing());
            if (!this.isRoutingsMutated) {
                this.routings.clear();
            }
            this.addRoutings(prototype.routings());
            this.name(prototype.name());
            this.host(prototype.host());
            this.address(prototype.address());
            this.port(prototype.port());
            this.backlog(prototype.backlog());
            this.maxPayloadSize(prototype.maxPayloadSize());
            this.receiveBufferSize(prototype.receiveBufferSize());
            this.writeQueueLength(prototype.writeQueueLength());
            this.smartAsyncWrites(prototype.smartAsyncWrites());
            this.writeBufferSize(prototype.writeBufferSize());
            this.shutdownGracePeriod(prototype.shutdownGracePeriod());
            this.connectionConfig(prototype.connectionConfig());
            this.tls(prototype.tls());
            this.contentEncoding(prototype.contentEncoding());
            this.mediaContext(prototype.mediaContext());
            this.connectionOptions(prototype.connectionOptions());
            this.maxTcpConnections(prototype.maxTcpConnections());
            this.maxConcurrentRequests(prototype.maxConcurrentRequests());
            this.concurrencyLimit(prototype.concurrencyLimit());
            this.concurrencyLimitDiscoverServices = false;
            this.idleConnectionTimeout(prototype.idleConnectionTimeout());
            this.idleConnectionPeriod(prototype.idleConnectionPeriod());
            this.maxInMemoryEntity(prototype.maxInMemoryEntity());
            this.addListenerSocketOptions(prototype.listenerSocketOptions());
            if (!this.isConnectionSelectorsMutated) {
                this.connectionSelectors.clear();
            }
            this.addConnectionSelectors(prototype.connectionSelectors());
            this.directHandlers(prototype.directHandlers());
            this.listenerContext(prototype.listenerContext());
            this.enableProxyProtocol(prototype.enableProxyProtocol());
            this.requestedUriDiscoveryContext(prototype.requestedUriDiscoveryContext());
            this.errorHandling(prototype.errorHandling());
            this.restoreResponseHeaders(prototype.restoreResponseHeaders());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            if (this.isProtocolsMutated) {
                if (builder.isProtocolsMutated) {
                    this.addProtocols(builder.protocols);
                }
            } else {
                this.protocols.clear();
                this.addProtocols(builder.protocols);
            }
            this.protocolsDiscoverServices = builder.protocolsDiscoverServices;
            builder.routing().ifPresent(this::routing);
            if (this.isRoutingsMutated) {
                if (builder.isRoutingsMutated) {
                    this.addRoutings(builder.routings);
                }
            } else {
                this.routings.clear();
                this.addRoutings(builder.routings);
            }
            this.name(builder.name());
            this.host(builder.host());
            builder.address().ifPresent(this::address);
            this.port(builder.port());
            this.backlog(builder.backlog());
            this.maxPayloadSize(builder.maxPayloadSize());
            builder.receiveBufferSize().ifPresent(this::receiveBufferSize);
            this.writeQueueLength(builder.writeQueueLength());
            this.smartAsyncWrites(builder.smartAsyncWrites());
            this.writeBufferSize(builder.writeBufferSize());
            this.shutdownGracePeriod(builder.shutdownGracePeriod());
            builder.connectionConfig().ifPresent(this::connectionConfig);
            builder.tls().ifPresent(this::tls);
            builder.contentEncoding().ifPresent(this::contentEncoding);
            builder.mediaContext().ifPresent(this::mediaContext);
            builder.connectionOptions().ifPresent(this::connectionOptions);
            this.maxTcpConnections(builder.maxTcpConnections());
            this.maxConcurrentRequests(builder.maxConcurrentRequests());
            builder.concurrencyLimit().ifPresent(this::concurrencyLimit);
            this.concurrencyLimitDiscoverServices = builder.concurrencyLimitDiscoverServices;
            this.idleConnectionTimeout(builder.idleConnectionTimeout());
            this.idleConnectionPeriod(builder.idleConnectionPeriod());
            this.maxInMemoryEntity(builder.maxInMemoryEntity());
            this.addListenerSocketOptions(builder.listenerSocketOptions);
            if (this.isConnectionSelectorsMutated) {
                if (builder.isConnectionSelectorsMutated) {
                    this.addConnectionSelectors(builder.connectionSelectors);
                }
            } else {
                this.connectionSelectors.clear();
                this.addConnectionSelectors(builder.connectionSelectors);
            }
            builder.directHandlers().ifPresent(this::directHandlers);
            builder.listenerContext().ifPresent(this::listenerContext);
            this.enableProxyProtocol(builder.enableProxyProtocol());
            builder.requestedUriDiscoveryContext().ifPresent(this::requestedUriDiscoveryContext);
            this.errorHandling(builder.errorHandling());
            this.restoreResponseHeaders(builder.restoreResponseHeaders());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER routing(Consumer<HttpRouting.Builder> builderConsumer) {
            WebServerConfigSupport.ListenerCustomMethods.routing(this, builderConsumer);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER config(Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("name").as(String.class).ifPresent(this::name);
            config.get("host").as(String.class).ifPresent(this::host);
            config.get("port").as(Integer.class).ifPresent(this::port);
            config.get("backlog").as(Integer.class).ifPresent(this::backlog);
            config.get("max-payload-size").as(Long.class).ifPresent(this::maxPayloadSize);
            config.get("receive-buffer-size").as(Integer.class).ifPresent(this::receiveBufferSize);
            config.get("write-queue-length").as(Integer.class).ifPresent(this::writeQueueLength);
            config.get("smart-async-writes").as(Boolean.class).ifPresent(this::smartAsyncWrites);
            config.get("write-buffer-size").as(Integer.class).ifPresent(this::writeBufferSize);
            config.get("shutdown-grace-period").as(Duration.class).ifPresent(this::shutdownGracePeriod);
            config.get("connection-config").map(ConnectionConfig::create).ifPresent(this::connectionConfig);
            config.get("tls").map(TlsConfig::create).ifPresent(this::tls);
            config.get("content-encoding").map(ContentEncodingContextConfig::create).ifPresent(this::contentEncoding);
            config.get("media-context").map(MediaContextConfig::create).ifPresent(this::mediaContext);
            config.get("connection-options").map(SocketOptions::create).ifPresent(this::connectionOptions);
            config.get("max-tcp-connections").as(Integer.class).ifPresent(this::maxTcpConnections);
            config.get("max-concurrent-requests").as(Integer.class).ifPresent(this::maxConcurrentRequests);
            config.get("idle-connection-timeout").as(Duration.class).ifPresent(this::idleConnectionTimeout);
            config.get("idle-connection-period").as(Duration.class).ifPresent(this::idleConnectionPeriod);
            config.get("max-in-memory-entity").as(Integer.class).ifPresent(this::maxInMemoryEntity);
            config.get("enable-proxy-protocol").as(Boolean.class).ifPresent(this::enableProxyProtocol);
            config.get("requested-uri-discovery").map(RequestedUriDiscoveryContext::create).ifPresent(this::requestedUriDiscoveryContext);
            config.get("error-handling").map(ErrorHandling::create).ifPresent(this::errorHandling);
            config.get("restore-response-headers").as(Boolean.class).ifPresent(this::restoreResponseHeaders);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER protocolsDiscoverServices(boolean discoverServices) {
            this.protocolsDiscoverServices = discoverServices;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER protocols(List<? extends ProtocolConfig> protocols) {
            Objects.requireNonNull(protocols);
            this.isProtocolsMutated = true;
            this.protocols.clear();
            this.protocols.addAll(protocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProtocols(List<? extends ProtocolConfig> protocols) {
            Objects.requireNonNull(protocols);
            this.isProtocolsMutated = true;
            this.protocols.addAll(protocols);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addProtocol(ProtocolConfig protocol) {
            Objects.requireNonNull(protocol);
            this.protocols.add(protocol);
            this.isProtocolsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRouting() {
            this.routing = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER routing(HttpRouting.Builder routing) {
            Objects.requireNonNull(routing);
            this.routing = routing;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER routings(List<io.helidon.common.Builder<?, ? extends Routing>> routings) {
            Objects.requireNonNull(routings);
            this.isRoutingsMutated = true;
            this.routings.clear();
            this.routings.addAll(routings);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRoutings(List<io.helidon.common.Builder<?, ? extends Routing>> routings) {
            Objects.requireNonNull(routings);
            this.isRoutingsMutated = true;
            this.routings.addAll(routings);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addRouting(io.helidon.common.Builder<?, ? extends Routing> routing) {
            Objects.requireNonNull(routing);
            this.routings.add(routing);
            this.isRoutingsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER host(String host) {
            Objects.requireNonNull(host);
            this.host = host;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER address(InetAddress address) {
            Objects.requireNonNull(address);
            this.address = address;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER port(int port) {
            this.port = port;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER backlog(int backlog) {
            this.backlog = backlog;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxPayloadSize(long maxPayloadSize) {
            this.maxPayloadSize = maxPayloadSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearReceiveBufferSize() {
            this.receiveBufferSize = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER receiveBufferSize(int receiveBufferSize) {
            Objects.requireNonNull(receiveBufferSize);
            this.receiveBufferSize = receiveBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER writeQueueLength(int writeQueueLength) {
            this.writeQueueLength = writeQueueLength;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER smartAsyncWrites(boolean smartAsyncWrites) {
            this.smartAsyncWrites = smartAsyncWrites;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER writeBufferSize(int writeBufferSize) {
            this.writeBufferSize = writeBufferSize;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER shutdownGracePeriod(Duration shutdownGracePeriod) {
            Objects.requireNonNull(shutdownGracePeriod);
            this.shutdownGracePeriod = shutdownGracePeriod;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearConnectionConfig() {
            this.connectionConfig = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectionConfig(ConnectionConfig connectionConfig) {
            Objects.requireNonNull(connectionConfig);
            this.connectionConfig = connectionConfig;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectionConfig(Consumer<ConnectionConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ConnectionConfig.Builder builder = ConnectionConfig.builder();
            consumer.accept(builder);
            this.connectionConfig(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearTls() {
            this.tls = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(Tls tls) {
            Objects.requireNonNull(tls);
            this.tls = tls;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(TlsConfig tlsConfig) {
            Objects.requireNonNull(tlsConfig);
            this.tls = Tls.create((TlsConfig)tlsConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER tls(Consumer<TlsConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TlsConfig.Builder builder = TlsConfig.builder();
            consumer.accept(builder);
            this.tls(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearContentEncoding() {
            this.contentEncoding = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncoding(ContentEncodingContext contentEncoding) {
            Objects.requireNonNull(contentEncoding);
            this.contentEncoding = contentEncoding;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncoding(ContentEncodingContextConfig contentEncodingConfig) {
            Objects.requireNonNull(contentEncodingConfig);
            this.contentEncoding = ContentEncodingContext.create((ContentEncodingContextConfig)contentEncodingConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER contentEncoding(Consumer<ContentEncodingContextConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ContentEncodingContextConfig.Builder builder = ContentEncodingContextConfig.builder();
            consumer.accept(builder);
            this.contentEncoding(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearMediaContext() {
            this.mediaContext = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaContext(MediaContext mediaContext) {
            Objects.requireNonNull(mediaContext);
            this.mediaContext = mediaContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaContext(MediaContextConfig mediaContextConfig) {
            Objects.requireNonNull(mediaContextConfig);
            this.mediaContext = MediaContext.create((MediaContextConfig)mediaContextConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER mediaContext(Consumer<MediaContextConfig.Builder> consumer) {
            Objects.requireNonNull(consumer);
            MediaContextConfig.Builder builder = MediaContextConfig.builder();
            consumer.accept(builder);
            this.mediaContext(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectionOptions(SocketOptions connectionOptions) {
            Objects.requireNonNull(connectionOptions);
            this.connectionOptions = connectionOptions;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectionOptions(Consumer<SocketOptions.Builder> consumer) {
            Objects.requireNonNull(consumer);
            SocketOptions.Builder builder = SocketOptions.builder();
            consumer.accept(builder);
            this.connectionOptions(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectionOptions(Supplier<? extends SocketOptions> supplier) {
            Objects.requireNonNull(supplier);
            this.connectionOptions(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxTcpConnections(int maxTcpConnections) {
            this.maxTcpConnections = maxTcpConnections;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxConcurrentRequests(int maxConcurrentRequests) {
            this.maxConcurrentRequests = maxConcurrentRequests;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearConcurrencyLimit() {
            this.concurrencyLimit = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER concurrencyLimit(Limit concurrencyLimit) {
            Objects.requireNonNull(concurrencyLimit);
            this.concurrencyLimit = concurrencyLimit;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER idleConnectionTimeout(Duration idleConnectionTimeout) {
            Objects.requireNonNull(idleConnectionTimeout);
            this.idleConnectionTimeout = idleConnectionTimeout;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER idleConnectionPeriod(Duration idleConnectionPeriod) {
            Objects.requireNonNull(idleConnectionPeriod);
            this.idleConnectionPeriod = idleConnectionPeriod;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER maxInMemoryEntity(int maxInMemoryEntity) {
            this.maxInMemoryEntity = maxInMemoryEntity;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER listenerSocketOptions(Map<SocketOption<?>, ?> listenerSocketOptions) {
            Objects.requireNonNull(listenerSocketOptions);
            this.listenerSocketOptions.clear();
            this.listenerSocketOptions.putAll(listenerSocketOptions);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addListenerSocketOptions(Map<SocketOption<?>, ?> listenerSocketOptions) {
            Objects.requireNonNull(listenerSocketOptions);
            this.listenerSocketOptions.putAll(listenerSocketOptions);
            return (BUILDER)((BuilderBase)this.self());
        }

        public <TYPE> BUILDER putListenerSocketOption(SocketOption<TYPE> key, TYPE listenerSocketOption) {
            Objects.requireNonNull(key);
            Objects.requireNonNull(listenerSocketOption);
            this.listenerSocketOptions.put(key, listenerSocketOption);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER connectionSelectors(List<? extends ServerConnectionSelector> connectionSelectors) {
            Objects.requireNonNull(connectionSelectors);
            this.isConnectionSelectorsMutated = true;
            this.connectionSelectors.clear();
            this.connectionSelectors.addAll(connectionSelectors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConnectionSelectors(List<? extends ServerConnectionSelector> connectionSelectors) {
            Objects.requireNonNull(connectionSelectors);
            this.isConnectionSelectorsMutated = true;
            this.connectionSelectors.addAll(connectionSelectors);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addConnectionSelector(ServerConnectionSelector connectionSelector) {
            Objects.requireNonNull(connectionSelector);
            this.connectionSelectors.add(connectionSelector);
            this.isConnectionSelectorsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearDirectHandlers() {
            this.directHandlers = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER directHandlers(DirectHandlers directHandlers) {
            Objects.requireNonNull(directHandlers);
            this.directHandlers = directHandlers;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER directHandlers(Consumer<DirectHandlers.Builder> consumer) {
            Objects.requireNonNull(consumer);
            DirectHandlers.Builder builder = DirectHandlers.builder();
            consumer.accept(builder);
            this.directHandlers(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearListenerContext() {
            this.listenerContext = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER listenerContext(Context listenerContext) {
            Objects.requireNonNull(listenerContext);
            this.listenerContext = listenerContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER listenerContext(Consumer<Context.Builder> consumer) {
            Objects.requireNonNull(consumer);
            Context.Builder builder = Context.builder();
            consumer.accept(builder);
            this.listenerContext(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER enableProxyProtocol(boolean enableProxyProtocol) {
            this.enableProxyProtocol = enableProxyProtocol;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearRequestedUriDiscoveryContext() {
            this.requestedUriDiscoveryContext = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requestedUriDiscoveryContext(RequestedUriDiscoveryContext requestedUriDiscoveryContext) {
            Objects.requireNonNull(requestedUriDiscoveryContext);
            this.requestedUriDiscoveryContext = requestedUriDiscoveryContext;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER requestedUriDiscoveryContext(Consumer<RequestedUriDiscoveryContext.Builder> consumer) {
            Objects.requireNonNull(consumer);
            RequestedUriDiscoveryContext.Builder builder = RequestedUriDiscoveryContext.builder();
            consumer.accept(builder);
            this.requestedUriDiscoveryContext(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER errorHandling(ErrorHandling errorHandling) {
            Objects.requireNonNull(errorHandling);
            this.errorHandling = errorHandling;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER errorHandling(Consumer<ErrorHandling.Builder> consumer) {
            Objects.requireNonNull(consumer);
            ErrorHandling.Builder builder = ErrorHandling.builder();
            consumer.accept(builder);
            this.errorHandling(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER errorHandling(Supplier<? extends ErrorHandling> supplier) {
            Objects.requireNonNull(supplier);
            this.errorHandling(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER restoreResponseHeaders(boolean restoreResponseHeaders) {
            this.restoreResponseHeaders = restoreResponseHeaders;
            return (BUILDER)((BuilderBase)this.self());
        }

        public List<ProtocolConfig> protocols() {
            return this.protocols;
        }

        public Optional<HttpRouting.Builder> routing() {
            return Optional.ofNullable(this.routing);
        }

        public List<io.helidon.common.Builder<?, ? extends Routing>> routings() {
            return this.routings;
        }

        public String name() {
            return this.name;
        }

        public String host() {
            return this.host;
        }

        public Optional<InetAddress> address() {
            return Optional.ofNullable(this.address);
        }

        public int port() {
            return this.port;
        }

        public int backlog() {
            return this.backlog;
        }

        public long maxPayloadSize() {
            return this.maxPayloadSize;
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public Optional<Integer> receiveBufferSize() {
            return Optional.ofNullable(this.receiveBufferSize);
        }

        public int writeQueueLength() {
            return this.writeQueueLength;
        }

        public boolean smartAsyncWrites() {
            return this.smartAsyncWrites;
        }

        public int writeBufferSize() {
            return this.writeBufferSize;
        }

        public Duration shutdownGracePeriod() {
            return this.shutdownGracePeriod;
        }

        @Deprecated(since="4.2.0", forRemoval=true)
        public Optional<ConnectionConfig> connectionConfig() {
            return Optional.ofNullable(this.connectionConfig);
        }

        public Optional<Tls> tls() {
            return Optional.ofNullable(this.tls);
        }

        public Optional<ContentEncodingContext> contentEncoding() {
            return Optional.ofNullable(this.contentEncoding);
        }

        public Optional<MediaContext> mediaContext() {
            return Optional.ofNullable(this.mediaContext);
        }

        public Optional<SocketOptions> connectionOptions() {
            return Optional.ofNullable(this.connectionOptions);
        }

        public int maxTcpConnections() {
            return this.maxTcpConnections;
        }

        public int maxConcurrentRequests() {
            return this.maxConcurrentRequests;
        }

        public Optional<Limit> concurrencyLimit() {
            return Optional.ofNullable(this.concurrencyLimit);
        }

        public Duration idleConnectionTimeout() {
            return this.idleConnectionTimeout;
        }

        public Duration idleConnectionPeriod() {
            return this.idleConnectionPeriod;
        }

        public int maxInMemoryEntity() {
            return this.maxInMemoryEntity;
        }

        public Map<SocketOption<?>, Object> listenerSocketOptions() {
            return this.listenerSocketOptions;
        }

        public List<ServerConnectionSelector> connectionSelectors() {
            return this.connectionSelectors;
        }

        public Optional<DirectHandlers> directHandlers() {
            return Optional.ofNullable(this.directHandlers);
        }

        public Optional<Context> listenerContext() {
            return Optional.ofNullable(this.listenerContext);
        }

        public boolean enableProxyProtocol() {
            return this.enableProxyProtocol;
        }

        public Optional<RequestedUriDiscoveryContext> requestedUriDiscoveryContext() {
            return Optional.ofNullable(this.requestedUriDiscoveryContext);
        }

        public ErrorHandling errorHandling() {
            return this.errorHandling;
        }

        public boolean restoreResponseHeaders() {
            return this.restoreResponseHeaders;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "ListenerConfigBuilder{protocols=" + String.valueOf(this.protocols) + ",routing=" + String.valueOf(this.routing) + ",routings=" + String.valueOf(this.routings) + ",name=" + this.name + ",host=" + this.host + ",address=" + String.valueOf(this.address) + ",port=" + this.port + ",backlog=" + this.backlog + ",maxPayloadSize=" + this.maxPayloadSize + ",receiveBufferSize=" + this.receiveBufferSize + ",writeQueueLength=" + this.writeQueueLength + ",smartAsyncWrites=" + this.smartAsyncWrites + ",writeBufferSize=" + this.writeBufferSize + ",shutdownGracePeriod=" + String.valueOf(this.shutdownGracePeriod) + ",connectionConfig=" + String.valueOf(this.connectionConfig) + ",tls=" + String.valueOf(this.tls) + ",contentEncoding=" + String.valueOf(this.contentEncoding) + ",mediaContext=" + String.valueOf(this.mediaContext) + ",connectionOptions=" + String.valueOf(this.connectionOptions) + ",maxTcpConnections=" + this.maxTcpConnections + ",maxConcurrentRequests=" + this.maxConcurrentRequests + ",concurrencyLimit=" + String.valueOf(this.concurrencyLimit) + ",idleConnectionTimeout=" + String.valueOf(this.idleConnectionTimeout) + ",idleConnectionPeriod=" + String.valueOf(this.idleConnectionPeriod) + ",maxInMemoryEntity=" + this.maxInMemoryEntity + ",listenerSocketOptions=" + String.valueOf(this.listenerSocketOptions) + ",connectionSelectors=" + String.valueOf(this.connectionSelectors) + ",directHandlers=" + String.valueOf(this.directHandlers) + ",listenerContext=" + String.valueOf(this.listenerContext) + ",enableProxyProtocol=" + this.enableProxyProtocol + ",requestedUriDiscoveryContext=" + String.valueOf(this.requestedUriDiscoveryContext) + ",errorHandling=" + String.valueOf(this.errorHandling) + ",restoreResponseHeaders=" + this.restoreResponseHeaders + "}";
        }

        protected void preBuildPrototype() {
            Config config = this.config == null ? Config.empty() : this.config;
            HelidonServiceLoader serviceLoader = HelidonServiceLoader.create(ServiceLoader.load(ProtocolConfigProvider.class));
            this.addProtocols(ConfigBuilderSupport.discoverServices((Config)config, (String)"protocols", (HelidonServiceLoader)serviceLoader, ProtocolConfigProvider.class, ProtocolConfig.class, (boolean)this.protocolsDiscoverServices, this.protocols));
            serviceLoader = HelidonServiceLoader.create(ServiceLoader.load(LimitProvider.class));
            ConfigBuilderSupport.discoverService((Config)config, (String)"concurrency-limit", (HelidonServiceLoader)serviceLoader, LimitProvider.class, Limit.class, (boolean)this.concurrencyLimitDiscoverServices, Optional.ofNullable(this.concurrencyLimit)).ifPresent(this::concurrencyLimit);
            new WebServerConfigSupport.ListenerConfigDecorator().decorate(this);
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.address == null) {
                collector.fatal(this.getClass(), "Property \"address\" must not be null, but not set");
            }
            if (this.connectionOptions == null) {
                collector.fatal(this.getClass(), "Property \"connection-options\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER routing(Optional<? extends HttpRouting.Builder> routing) {
            Objects.requireNonNull(routing);
            this.routing = routing.map(HttpRouting.Builder.class::cast).orElse(this.routing);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER receiveBufferSize(Optional<Integer> receiveBufferSize) {
            Objects.requireNonNull(receiveBufferSize);
            this.receiveBufferSize = receiveBufferSize.map(Integer.class::cast).orElse(this.receiveBufferSize);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER connectionConfig(Optional<? extends ConnectionConfig> connectionConfig) {
            Objects.requireNonNull(connectionConfig);
            this.connectionConfig = connectionConfig.map(ConnectionConfig.class::cast).orElse(this.connectionConfig);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER tls(Optional<? extends Tls> tls) {
            Objects.requireNonNull(tls);
            this.tls = tls.map(Tls.class::cast).orElse(this.tls);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER contentEncoding(Optional<? extends ContentEncodingContext> contentEncoding) {
            Objects.requireNonNull(contentEncoding);
            this.contentEncoding = contentEncoding.map(ContentEncodingContext.class::cast).orElse(this.contentEncoding);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER mediaContext(Optional<? extends MediaContext> mediaContext) {
            Objects.requireNonNull(mediaContext);
            this.mediaContext = mediaContext.map(MediaContext.class::cast).orElse(this.mediaContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER concurrencyLimit(Optional<? extends Limit> concurrencyLimit) {
            Objects.requireNonNull(concurrencyLimit);
            this.concurrencyLimit = concurrencyLimit.map(Limit.class::cast).orElse(this.concurrencyLimit);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER directHandlers(Optional<? extends DirectHandlers> directHandlers) {
            Objects.requireNonNull(directHandlers);
            this.directHandlers = directHandlers.map(DirectHandlers.class::cast).orElse(this.directHandlers);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER listenerContext(Optional<? extends Context> listenerContext) {
            Objects.requireNonNull(listenerContext);
            this.listenerContext = listenerContext.map(Context.class::cast).orElse(this.listenerContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        BUILDER requestedUriDiscoveryContext(Optional<? extends RequestedUriDiscoveryContext> requestedUriDiscoveryContext) {
            Objects.requireNonNull(requestedUriDiscoveryContext);
            this.requestedUriDiscoveryContext = requestedUriDiscoveryContext.map(RequestedUriDiscoveryContext.class::cast).orElse(this.requestedUriDiscoveryContext);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class ListenerConfigImpl
        implements ListenerConfig {
            private final boolean enableProxyProtocol;
            private final boolean restoreResponseHeaders;
            private final boolean smartAsyncWrites;
            private final Duration idleConnectionPeriod;
            private final Duration idleConnectionTimeout;
            private final Duration shutdownGracePeriod;
            private final ErrorHandling errorHandling;
            private final InetAddress address;
            private final int backlog;
            private final int maxConcurrentRequests;
            private final int maxInMemoryEntity;
            private final int maxTcpConnections;
            private final int port;
            private final int writeBufferSize;
            private final int writeQueueLength;
            private final List<io.helidon.common.Builder<?, ? extends Routing>> routings;
            private final List<ProtocolConfig> protocols;
            private final List<ServerConnectionSelector> connectionSelectors;
            private final long maxPayloadSize;
            private final Map<SocketOption<?>, Object> listenerSocketOptions;
            private final Optional<ConnectionConfig> connectionConfig;
            private final Optional<Limit> concurrencyLimit;
            private final Optional<Context> listenerContext;
            private final Optional<Tls> tls;
            private final Optional<RequestedUriDiscoveryContext> requestedUriDiscoveryContext;
            private final Optional<ContentEncodingContext> contentEncoding;
            private final Optional<MediaContext> mediaContext;
            private final Optional<DirectHandlers> directHandlers;
            private final Optional<HttpRouting.Builder> routing;
            private final Optional<Integer> receiveBufferSize;
            private final SocketOptions connectionOptions;
            private final String host;
            private final String name;

            protected ListenerConfigImpl(BuilderBase<?, ?> builder) {
                this.protocols = List.copyOf(builder.protocols());
                this.routing = builder.routing();
                this.routings = List.copyOf(builder.routings());
                this.name = builder.name();
                this.host = builder.host();
                this.address = builder.address().get();
                this.port = builder.port();
                this.backlog = builder.backlog();
                this.maxPayloadSize = builder.maxPayloadSize();
                this.receiveBufferSize = builder.receiveBufferSize();
                this.writeQueueLength = builder.writeQueueLength();
                this.smartAsyncWrites = builder.smartAsyncWrites();
                this.writeBufferSize = builder.writeBufferSize();
                this.shutdownGracePeriod = builder.shutdownGracePeriod();
                this.connectionConfig = builder.connectionConfig();
                this.tls = builder.tls();
                this.contentEncoding = builder.contentEncoding();
                this.mediaContext = builder.mediaContext();
                this.connectionOptions = builder.connectionOptions().get();
                this.maxTcpConnections = builder.maxTcpConnections();
                this.maxConcurrentRequests = builder.maxConcurrentRequests();
                this.concurrencyLimit = builder.concurrencyLimit();
                this.idleConnectionTimeout = builder.idleConnectionTimeout();
                this.idleConnectionPeriod = builder.idleConnectionPeriod();
                this.maxInMemoryEntity = builder.maxInMemoryEntity();
                this.listenerSocketOptions = Collections.unmodifiableMap(new LinkedHashMap(builder.listenerSocketOptions()));
                this.connectionSelectors = List.copyOf(builder.connectionSelectors());
                this.directHandlers = builder.directHandlers();
                this.listenerContext = builder.listenerContext();
                this.enableProxyProtocol = builder.enableProxyProtocol();
                this.requestedUriDiscoveryContext = builder.requestedUriDiscoveryContext();
                this.errorHandling = builder.errorHandling();
                this.restoreResponseHeaders = builder.restoreResponseHeaders();
            }

            @Override
            public List<ProtocolConfig> protocols() {
                return this.protocols;
            }

            @Override
            public Optional<HttpRouting.Builder> routing() {
                return this.routing;
            }

            @Override
            public List<io.helidon.common.Builder<?, ? extends Routing>> routings() {
                return this.routings;
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String host() {
                return this.host;
            }

            @Override
            public InetAddress address() {
                return this.address;
            }

            @Override
            public int port() {
                return this.port;
            }

            @Override
            public int backlog() {
                return this.backlog;
            }

            @Override
            public long maxPayloadSize() {
                return this.maxPayloadSize;
            }

            @Override
            public Optional<Integer> receiveBufferSize() {
                return this.receiveBufferSize;
            }

            @Override
            public int writeQueueLength() {
                return this.writeQueueLength;
            }

            @Override
            public boolean smartAsyncWrites() {
                return this.smartAsyncWrites;
            }

            @Override
            public int writeBufferSize() {
                return this.writeBufferSize;
            }

            @Override
            public Duration shutdownGracePeriod() {
                return this.shutdownGracePeriod;
            }

            @Override
            public Optional<ConnectionConfig> connectionConfig() {
                return this.connectionConfig;
            }

            @Override
            public Optional<Tls> tls() {
                return this.tls;
            }

            @Override
            public Optional<ContentEncodingContext> contentEncoding() {
                return this.contentEncoding;
            }

            @Override
            public Optional<MediaContext> mediaContext() {
                return this.mediaContext;
            }

            @Override
            public SocketOptions connectionOptions() {
                return this.connectionOptions;
            }

            @Override
            public int maxTcpConnections() {
                return this.maxTcpConnections;
            }

            @Override
            public int maxConcurrentRequests() {
                return this.maxConcurrentRequests;
            }

            @Override
            public Optional<Limit> concurrencyLimit() {
                return this.concurrencyLimit;
            }

            @Override
            public Duration idleConnectionTimeout() {
                return this.idleConnectionTimeout;
            }

            @Override
            public Duration idleConnectionPeriod() {
                return this.idleConnectionPeriod;
            }

            @Override
            public int maxInMemoryEntity() {
                return this.maxInMemoryEntity;
            }

            @Override
            public Map<SocketOption<?>, Object> listenerSocketOptions() {
                return this.listenerSocketOptions;
            }

            @Override
            public List<ServerConnectionSelector> connectionSelectors() {
                return this.connectionSelectors;
            }

            @Override
            public Optional<DirectHandlers> directHandlers() {
                return this.directHandlers;
            }

            @Override
            public Optional<Context> listenerContext() {
                return this.listenerContext;
            }

            @Override
            public boolean enableProxyProtocol() {
                return this.enableProxyProtocol;
            }

            @Override
            public Optional<RequestedUriDiscoveryContext> requestedUriDiscoveryContext() {
                return this.requestedUriDiscoveryContext;
            }

            @Override
            public ErrorHandling errorHandling() {
                return this.errorHandling;
            }

            @Override
            public boolean restoreResponseHeaders() {
                return this.restoreResponseHeaders;
            }

            public String toString() {
                return "ListenerConfig{protocols=" + String.valueOf(this.protocols) + ",routing=" + String.valueOf(this.routing) + ",routings=" + String.valueOf(this.routings) + ",name=" + this.name + ",host=" + this.host + ",address=" + String.valueOf(this.address) + ",port=" + this.port + ",backlog=" + this.backlog + ",maxPayloadSize=" + this.maxPayloadSize + ",receiveBufferSize=" + String.valueOf(this.receiveBufferSize) + ",writeQueueLength=" + this.writeQueueLength + ",smartAsyncWrites=" + this.smartAsyncWrites + ",writeBufferSize=" + this.writeBufferSize + ",shutdownGracePeriod=" + String.valueOf(this.shutdownGracePeriod) + ",connectionConfig=" + String.valueOf(this.connectionConfig) + ",tls=" + String.valueOf(this.tls) + ",contentEncoding=" + String.valueOf(this.contentEncoding) + ",mediaContext=" + String.valueOf(this.mediaContext) + ",connectionOptions=" + String.valueOf(this.connectionOptions) + ",maxTcpConnections=" + this.maxTcpConnections + ",maxConcurrentRequests=" + this.maxConcurrentRequests + ",concurrencyLimit=" + String.valueOf(this.concurrencyLimit) + ",idleConnectionTimeout=" + String.valueOf(this.idleConnectionTimeout) + ",idleConnectionPeriod=" + String.valueOf(this.idleConnectionPeriod) + ",maxInMemoryEntity=" + this.maxInMemoryEntity + ",listenerSocketOptions=" + String.valueOf(this.listenerSocketOptions) + ",connectionSelectors=" + String.valueOf(this.connectionSelectors) + ",directHandlers=" + String.valueOf(this.directHandlers) + ",listenerContext=" + String.valueOf(this.listenerContext) + ",enableProxyProtocol=" + this.enableProxyProtocol + ",requestedUriDiscoveryContext=" + String.valueOf(this.requestedUriDiscoveryContext) + ",errorHandling=" + String.valueOf(this.errorHandling) + ",restoreResponseHeaders=" + this.restoreResponseHeaders + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ListenerConfig)) {
                    return false;
                }
                ListenerConfig other = (ListenerConfig)o;
                return Objects.equals(this.protocols, other.protocols()) && Objects.equals(this.routing, other.routing()) && Objects.equals(this.routings, other.routings()) && Objects.equals(this.name, other.name()) && Objects.equals(this.host, other.host()) && Objects.equals(this.address, other.address()) && this.port == other.port() && this.backlog == other.backlog() && this.maxPayloadSize == other.maxPayloadSize() && Objects.equals(this.receiveBufferSize, other.receiveBufferSize()) && this.writeQueueLength == other.writeQueueLength() && this.smartAsyncWrites == other.smartAsyncWrites() && this.writeBufferSize == other.writeBufferSize() && Objects.equals(this.shutdownGracePeriod, other.shutdownGracePeriod()) && Objects.equals(this.connectionConfig, other.connectionConfig()) && Objects.equals(this.tls, other.tls()) && Objects.equals(this.contentEncoding, other.contentEncoding()) && Objects.equals(this.mediaContext, other.mediaContext()) && Objects.equals(this.connectionOptions, other.connectionOptions()) && this.maxTcpConnections == other.maxTcpConnections() && this.maxConcurrentRequests == other.maxConcurrentRequests() && Objects.equals(this.concurrencyLimit, other.concurrencyLimit()) && Objects.equals(this.idleConnectionTimeout, other.idleConnectionTimeout()) && Objects.equals(this.idleConnectionPeriod, other.idleConnectionPeriod()) && this.maxInMemoryEntity == other.maxInMemoryEntity() && Objects.equals(this.listenerSocketOptions, other.listenerSocketOptions()) && Objects.equals(this.connectionSelectors, other.connectionSelectors()) && Objects.equals(this.directHandlers, other.directHandlers()) && Objects.equals(this.listenerContext, other.listenerContext()) && this.enableProxyProtocol == other.enableProxyProtocol() && Objects.equals(this.requestedUriDiscoveryContext, other.requestedUriDiscoveryContext()) && Objects.equals(this.errorHandling, other.errorHandling()) && this.restoreResponseHeaders == other.restoreResponseHeaders();
            }

            public int hashCode() {
                return Objects.hash(this.protocols, this.routing, this.routings, this.name, this.host, this.address, this.port, this.backlog, this.maxPayloadSize, this.receiveBufferSize, this.writeQueueLength, this.smartAsyncWrites, this.writeBufferSize, this.shutdownGracePeriod, this.connectionConfig, this.tls, this.contentEncoding, this.mediaContext, this.connectionOptions, this.maxTcpConnections, this.maxConcurrentRequests, this.concurrencyLimit, this.idleConnectionTimeout, this.idleConnectionPeriod, this.maxInMemoryEntity, this.listenerSocketOptions, this.connectionSelectors, this.directHandlers, this.listenerContext, this.enableProxyProtocol, this.requestedUriDiscoveryContext, this.errorHandling, this.restoreResponseHeaders);
            }
        }
    }
}

