/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.account.MutableAccount;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class SelfDestructOperation
extends AbstractOperation {
    final boolean eip6780Semantics;

    public SelfDestructOperation(GasCalculator gasCalculator) {
        this(gasCalculator, false);
    }

    public SelfDestructOperation(GasCalculator gasCalculator, boolean eip6780Semantics) {
        super(255, "SELFDESTRUCT", 1, 0, gasCalculator);
        this.eip6780Semantics = eip6780Semantics;
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        Address beneficiaryAddress = Words.toAddress(frame.popStackItem());
        Account beneficiaryNullable = frame.getWorldUpdater().get(beneficiaryAddress);
        boolean beneficiaryIsWarm = frame.warmUpAddress(beneficiaryAddress) || this.gasCalculator().isPrecompile(beneficiaryAddress);
        Address originatorAddress = frame.getRecipientAddress();
        MutableAccount originatorAccount = frame.getWorldUpdater().getAccount(originatorAddress);
        Wei originatorBalance = originatorAccount.getBalance();
        long cost = this.gasCalculator().selfDestructOperationGasCost(beneficiaryNullable, originatorBalance) + (beneficiaryIsWarm ? 0L : this.gasCalculator().getColdAccountAccessCost());
        if (frame.isStatic()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        MutableAccount beneficiaryAccount = frame.getWorldUpdater().getOrCreate(beneficiaryAddress);
        originatorAccount.decrementBalance(originatorBalance);
        beneficiaryAccount.incrementBalance(originatorBalance);
        if (!this.eip6780Semantics || frame.wasCreatedInTransaction(originatorAccount.getAddress())) {
            frame.addSelfDestruct(originatorAccount.getAddress());
            originatorAccount.setBalance(Wei.ZERO);
        }
        frame.addRefund(beneficiaryAddress, originatorBalance);
        frame.setState(MessageFrame.State.CODE_SUCCESS);
        return new Operation.OperationResult(cost, null);
    }
}

