/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.hapi.fees.apis.common;

import com.hedera.hapi.node.base.HederaFunctionality;
import java.security.InvalidParameterException;
import java.util.Map;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.fees.apis.common.AbstractBaseFeeModel;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.ExtraFeeReference;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class StandardFeeModel
extends AbstractBaseFeeModel {
    public StandardFeeModel(HederaFunctionality api, String description) {
        super(api, description);
    }

    @Override
    public FeeResult computeFee(Map<Extra, Long> params, FeeSchedule feeSchedule) {
        FeeResult result = this.computeNodeAndNetworkFees(params, feeSchedule);
        result.addServiceFee("Base Fee for " + String.valueOf(this.getApi()), 1L, FeeScheduleUtils.lookupServiceFee(feeSchedule, this.getApi()).baseFee());
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee(feeSchedule, this.getApi());
        for (ExtraFeeReference ref : serviceDef.extras()) {
            if (!params.containsKey(ref.name())) {
                throw new InvalidParameterException("input params missing " + String.valueOf(ref.name()) + " required by method " + String.valueOf(this.getApi()));
            }
            int included = ref.includedCount();
            long used = params.get(ref.name());
            long extraFee = FeeScheduleUtils.lookupExtraFee(feeSchedule, ref.name()).fee();
            if (used <= (long)included) continue;
            long overage = used - (long)included;
            result.addServiceFee("Overage of " + ref.name().name(), overage, overage * extraFee);
        }
        return result;
    }
}

