/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.mutable.primitive;

import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.iterator.MutableDoubleIterator;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.ParallelUnsortedSetIterable;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.impl.set.mutable.AbstractMutableSet;

public class BoxedMutableDoubleSet
extends AbstractMutableSet<Double>
implements MutableSet<Double> {
    private final MutableDoubleSet delegate;

    public BoxedMutableDoubleSet(MutableDoubleSet delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    public Double getFirst() {
        throw new UnsupportedOperationException();
    }

    public Double getLast() {
        throw new UnsupportedOperationException();
    }

    public void each(Procedure<? super Double> procedure) {
        this.delegate.each(arg_0 -> procedure.value(arg_0));
    }

    @Override
    public boolean add(Double item) {
        return this.delegate.add(item.doubleValue());
    }

    @Override
    public boolean contains(Object object) {
        return object instanceof Double && this.delegate.contains(((Double)object).doubleValue());
    }

    @Override
    public boolean remove(Object object) {
        return object instanceof Double && this.delegate.remove(((Double)object).doubleValue());
    }

    public void clear() {
        this.delegate.clear();
    }

    public ParallelUnsortedSetIterable<Double> asParallel(ExecutorService executorService, int batchSize) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set other = (Set)object;
        return this.size() == other.size() && this.containsAll(other);
    }

    public Iterator<Double> iterator() {
        return new BoxedPrimitiveDoubleSetIterator(this.delegate.doubleIterator());
    }

    private static final class BoxedPrimitiveDoubleSetIterator
    implements Iterator<Double> {
        private final MutableDoubleIterator delegate;

        private BoxedPrimitiveDoubleSetIterator(MutableDoubleIterator iterator) {
            this.delegate = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public Double next() {
            return this.delegate.next();
        }
    }
}

