/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class EqOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult eqSuccess = new Operation.OperationResult(3L, null);

    public EqOperation(GasCalculator gasCalculator) {
        super(20, "EQ", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return EqOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes value1;
        Bytes value0 = frame.popStackItem().trimLeadingZeros();
        UInt256 result = value0.equals((Object)(value1 = frame.popStackItem().trimLeadingZeros())) ? UInt256.ONE : UInt256.ZERO;
        frame.pushStackItem((Bytes)result);
        return eqSuccess;
    }
}

