/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.pki;

import io.helidon.common.pki.PkiException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HexFormat;

final class Pkcs1Util {
    private static final byte[] RSA_ALG = HexFormat.of().parseHex("020100300D06092A864886F70D0101010500");

    private Pkcs1Util() {
    }

    static KeySpec pkcs1RsaKeySpec(byte[] bytes) {
        return new PKCS8EncodedKeySpec(Pkcs1Util.pkcs1ToPkcs8(bytes));
    }

    private static byte[] pkcs1ToPkcs8(byte[] pkcs1Bytes) {
        byte[] len2 = Pkcs1Util.encodeLen(pkcs1Bytes.length);
        int p8len = pkcs1Bytes.length + len2.length + 1 + RSA_ALG.length;
        byte[] len1 = Pkcs1Util.encodeLen(p8len);
        byte[] pkcs8bytes = new byte[1 + len1.length + p8len];
        pkcs8bytes[0] = 48;
        System.arraycopy(len1, 0, pkcs8bytes, 1, len1.length);
        System.arraycopy(RSA_ALG, 0, pkcs8bytes, 1 + len1.length, RSA_ALG.length);
        pkcs8bytes[1 + len1.length + Pkcs1Util.RSA_ALG.length] = 4;
        System.arraycopy(len2, 0, pkcs8bytes, 1 + len1.length + RSA_ALG.length + 1, len2.length);
        System.arraycopy(pkcs1Bytes, 0, pkcs8bytes, 1 + len1.length + RSA_ALG.length + 1 + len2.length, pkcs1Bytes.length);
        return pkcs8bytes;
    }

    private static byte[] encodeLen(int len) {
        if (len < 128) {
            return new byte[]{(byte)len};
        }
        if (len < 256) {
            return new byte[]{-127, (byte)len};
        }
        if (len < 65536) {
            return new byte[]{-126, (byte)(len >> 8), (byte)len};
        }
        throw new PkiException("PKCS#1 key of unexpected size: " + len);
    }
}

