/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl;

import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.token.StakingNodeInfo;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.token.impl.ReadableStakingInfoStoreImpl;
import com.hedera.node.app.service.token.impl.schemas.V0490TokenSchema;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class WritableStakingInfoStore
extends ReadableStakingInfoStoreImpl {
    private final WritableKVState<EntityNumber, StakingNodeInfo> stakingInfoState;
    private final WritableEntityCounters entityCounters;

    public WritableStakingInfoStore(@NonNull WritableStates states, WritableEntityCounters entityCounters) {
        super((ReadableStates)states, (ReadableEntityCounters)entityCounters);
        Objects.requireNonNull(states);
        this.stakingInfoState = states.get(V0490TokenSchema.STAKING_INFOS_STATE_ID);
        this.entityCounters = Objects.requireNonNull(entityCounters);
    }

    public void put(long nodeId, @NonNull StakingNodeInfo stakingNodeInfo) {
        Objects.requireNonNull(stakingNodeInfo);
        this.stakingInfoState.put((Object)EntityNumber.newBuilder().number(nodeId).build(), (Object)stakingNodeInfo);
    }

    public void putAndIncrementCount(long nodeId, @NonNull StakingNodeInfo stakingNodeInfo) {
        this.put(nodeId, stakingNodeInfo);
        this.entityCounters.incrementEntityTypeCount(EntityType.STAKING_INFO);
    }

    @Nullable
    public StakingNodeInfo getOriginalValue(long nodeId) {
        return (StakingNodeInfo)this.stakingInfoState.getOriginalValue((Object)EntityNumber.newBuilder().number(nodeId).build());
    }
}

