/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.token.ReadableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.api.StakingRewardsApi;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.data.StakingConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.time.InstantSource;
import java.time.ZoneId;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StakePeriodManager {
    public static final ZoneId ZONE_UTC = ZoneId.of("UTC");
    public static final long DEFAULT_STAKING_PERIOD_MINS = 1440L;
    private final int numStoredPeriods;
    private final long stakingPeriodMins;
    private final InstantSource instantSource;
    private long currentStakePeriod;
    private long prevConsensusSecs;

    @Inject
    public StakePeriodManager(@NonNull ConfigProvider configProvider, @NonNull InstantSource instantSource) {
        StakingConfig config = (StakingConfig)configProvider.getConfiguration().getConfigData(StakingConfig.class);
        this.numStoredPeriods = config.rewardHistoryNumStoredPeriods();
        this.stakingPeriodMins = config.periodMins();
        this.instantSource = Objects.requireNonNull(instantSource);
    }

    public long epochSecondAtStartOfPeriod(long stakePeriod) {
        return StakingRewardsApi.epochSecondAtStartOfPeriod((long)stakePeriod, (long)this.stakingPeriodMins);
    }

    public void setCurrentStakePeriodFor(@NonNull Instant consensusNow) {
        long currentConsensusSecs = consensusNow.getEpochSecond();
        if (this.prevConsensusSecs != currentConsensusSecs) {
            this.currentStakePeriod = StakingRewardsApi.stakePeriodAt((Instant)consensusNow, (long)this.stakingPeriodMins);
            this.prevConsensusSecs = currentConsensusSecs;
        }
    }

    public long currentStakePeriod() {
        return this.currentStakePeriod;
    }

    public boolean isRewardable(long stakePeriodStart, @NonNull ReadableNetworkStakingRewardsStore networkRewards) {
        return stakePeriodStart > -1L && stakePeriodStart < this.firstNonRewardableStakePeriod(networkRewards);
    }

    public long firstNonRewardableStakePeriod(@NonNull ReadableNetworkStakingRewardsStore rewardsStore) {
        return rewardsStore.isStakingRewardsActivated() ? this.currentStakePeriod() - 1L : Long.MIN_VALUE;
    }

    public long effectivePeriod(long stakePeriodStart) {
        return StakingRewardsApi.clampedStakePeriodStart((long)stakePeriodStart, (long)this.currentStakePeriod, (int)this.numStoredPeriods);
    }

    public long estimatedCurrentStakePeriod() {
        return StakingRewardsApi.estimatedCurrentStakePeriod((long)this.stakingPeriodMins, (Instant)this.instantSource.instant());
    }

    public long estimatedFirstNonRewardableStakePeriod(@NonNull ReadableNetworkStakingRewardsStore networkRewards) {
        return networkRewards.isStakingRewardsActivated() ? this.estimatedCurrentStakePeriod() - 1L : Long.MIN_VALUE;
    }

    public boolean isEstimatedRewardable(long stakePeriodStart, @NonNull ReadableNetworkStakingRewardsStore networkRewards) {
        return StakingRewardsApi.isEstimatedRewardable((long)this.stakingPeriodMins, (long)stakePeriodStart, (boolean)networkRewards.isStakingRewardsActivated(), (Instant)this.instantSource.instant());
    }

    public long startUpdateFor(@Nullable Account originalAccount, @NonNull Account modifiedAccount, boolean rewarded, boolean stakeMetaChanged) {
        if (modifiedAccount.hasStakedNodeId()) {
            if (originalAccount != null && originalAccount.hasStakedAccountId() || stakeMetaChanged) {
                return this.currentStakePeriod();
            }
            if (rewarded) {
                return this.currentStakePeriod() - 1L;
            }
        }
        return -1L;
    }

    @VisibleForTesting
    public long getPrevConsensusSecs() {
        return this.prevConsensusSecs;
    }
}

