/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.UnitType;
import com.esaulpaugh.headlong.util.Integers;
import com.esaulpaugh.headlong.util.Uint;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;

final class PackedDecoder {
    private PackedDecoder() {
    }

    static int checkDynamics(ABIType<?> type) {
        int count = 0;
        if (type.dynamic) {
            if (type instanceof ArrayType) {
                ArrayType at = type.asArrayType();
                count = PackedDecoder.checkDynamics(at.getElementType());
                if (-1 == at.getLength()) {
                    ++count;
                }
            } else {
                for (ABIType<?> e : type.asTupleType().elementTypes) {
                    count += PackedDecoder.checkDynamics(e);
                }
            }
            if (count > 1) {
                throw new IllegalArgumentException("multiple dynamic elements: " + count);
            }
        }
        return count;
    }

    private static Tuple decodeTuple(TupleType<?> tupleType, ByteBuffer bb, int end) {
        int i;
        Object[] elements = new Object[tupleType.size()];
        int start = bb.position();
        int firstDynamicIndex = -1;
        for (i = elements.length - 1; i >= 0; --i) {
            Object type = tupleType.get(i);
            if (((ABIType)type).dynamic) {
                firstDynamicIndex = i;
                break;
            }
            if (type instanceof ArrayType) {
                ArrayType arrayType = ((ABIType)type).asArrayType();
                int elementByteLength = arrayType.getElementType() instanceof UnitType ? 32 : ((ABIType)arrayType.getElementType()).byteLengthPacked(null);
                bb.position(end -= elementByteLength * arrayType.getLength());
                elements[i] = PackedDecoder.decodeArray(arrayType, bb, -1);
                continue;
            }
            if (type instanceof TupleType) {
                bb.position(end -= ((ABIType)type).byteLengthPacked(null));
                elements[i] = PackedDecoder.decodeTupleStatic(((ABIType)type).asTupleType(), bb);
                continue;
            }
            bb.position(end -= ((ABIType)type).byteLengthPacked(null));
            elements[i] = PackedDecoder.decode(type, bb, -1);
        }
        for (i = 0; i <= firstDynamicIndex; ++i) {
            Object e;
            Object t = tupleType.get(i);
            bb.position(start);
            elements[i] = e = PackedDecoder.decode(t, bb, end);
            start += ((ABIType)t).byteLengthPacked((Object)e);
        }
        return Tuple.create(elements);
    }

    static Object decode(ABIType<?> type, ByteBuffer bb, int end) {
        switch (type.typeCode()) {
            case 0: {
                return BooleanType.decodeBoolean(bb.get());
            }
            case 1: {
                return bb.get();
            }
            case 2: {
                return (int)PackedDecoder.decodeLong((IntType)type, bb, type.byteLengthPacked(null));
            }
            case 3: {
                return PackedDecoder.decodeLong((LongType)type, bb, type.byteLengthPacked(null));
            }
            case 4: {
                return PackedDecoder.decodeBigInteger((BigIntegerType)type, type.byteLengthPacked(null), bb);
            }
            case 5: {
                return PackedDecoder.decodeBigDecimal((BigDecimalType)type, type.byteLengthPacked(null), bb);
            }
            case 6: {
                return PackedDecoder.decodeArray(type.asArrayType(), bb, end);
            }
            case 7: {
                return type.dynamic ? PackedDecoder.decodeTuple(type.asTupleType(), bb, end) : PackedDecoder.decodeTupleStatic(type.asTupleType(), bb);
            }
            case 8: {
                return new Address(PackedDecoder.getBigInt(bb, type.byteLengthPacked(null)));
            }
        }
        throw new AssertionError();
    }

    private static Tuple decodeTupleStatic(TupleType<?> tupleType, ByteBuffer bb) {
        Object[] elements = new Object[tupleType.size()];
        for (int i = 0; i < elements.length; ++i) {
            int prev = bb.position();
            Object t = tupleType.get(i);
            elements[i] = PackedDecoder.decode(t, bb, -1);
            bb.position(prev + ((ABIType)t).byteLengthPacked(null));
        }
        return Tuple.create(elements);
    }

    private static BigInteger decodeBigInteger(BigIntegerType type, int elementLen, ByteBuffer bb) {
        if (type.unsigned) {
            return PackedDecoder.getBigInt(bb, elementLen);
        }
        return PackedDecoder.getSignedBigInt(bb, elementLen);
    }

    private static BigDecimal decodeBigDecimal(BigDecimalType type, int elementLen, ByteBuffer bb) {
        return new BigDecimal(type.unsigned ? PackedDecoder.getBigInt(bb, elementLen) : PackedDecoder.getSignedBigInt(bb, elementLen), type.scale);
    }

    private static BigInteger getBigInt(ByteBuffer bb, int elementLen) {
        return Integers.getBigInt(bb.array(), bb.position(), elementLen, true);
    }

    private static BigInteger getSignedBigInt(ByteBuffer bb, int elementLen) {
        byte[] temp = new byte[elementLen];
        bb.get(temp);
        return new BigInteger(temp);
    }

    private static Object decodeArray(ArrayType<ABIType<Object>, ?, ?> arrayType, ByteBuffer bb, int end) {
        Object array;
        int arrayLen;
        ABIType<Object> elementType = arrayType.getElementType();
        int elementByteLen = elementType instanceof UnitType ? 32 : elementType.byteLengthPacked(null);
        int typeLen = arrayType.getLength();
        if (-1 == typeLen) {
            if (elementByteLen == 0) {
                throw new IllegalArgumentException("can't decode dynamic number of zero-length elements");
            }
            arrayLen = (end - bb.position()) / elementByteLen;
        } else {
            arrayLen = typeLen;
        }
        switch (elementType.typeCode()) {
            case 0: {
                array = PackedDecoder.decodeBooleanArray(arrayLen, bb);
                break;
            }
            case 1: {
                array = PackedDecoder.decodeByteArray(arrayType, arrayLen, bb);
                break;
            }
            case 2: {
                array = PackedDecoder.decodeIntArray(arrayLen, bb);
                break;
            }
            case 3: {
                array = PackedDecoder.decodeLongArray(arrayLen, bb);
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                array = PackedDecoder.decodeElements(elementType, arrayLen, bb);
                break;
            }
            case 6: 
            case 7: {
                array = PackedDecoder.decodeObjectArray(elementType, arrayLen, bb);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return array;
    }

    private static boolean[] decodeBooleanArray(int arrayLen, ByteBuffer bb) {
        boolean[] booleans = new boolean[arrayLen];
        byte[] unitBuffer = ABIType.newUnitBuffer();
        for (int i = 0; i < booleans.length; ++i) {
            booleans[i] = BooleanType.INSTANCE.decode(bb, unitBuffer);
        }
        return booleans;
    }

    private static Object decodeByteArray(ArrayType<?, ?, ?> arrayType, int arrayLen, ByteBuffer bb) {
        byte[] bytes = new byte[arrayLen];
        bb.get(bytes);
        return arrayType.encodeIfString(bytes);
    }

    private static int[] decodeIntArray(int arrayLen, ByteBuffer bb) {
        int[] ints = new int[arrayLen];
        for (int i = 0; i < ints.length; ++i) {
            long value = PackedDecoder.decodeSignedLong(bb, 32);
            if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
                throw new ArithmeticException("overflow");
            }
            ints[i] = (int)value;
        }
        return ints;
    }

    private static long[] decodeLongArray(int arrayLen, ByteBuffer bb) {
        long[] longs = new long[arrayLen];
        for (int i = 0; i < longs.length; ++i) {
            longs[i] = PackedDecoder.decodeSignedLong(bb, 32);
        }
        return longs;
    }

    private static Object[] decodeElements(ABIType<Object> elementType, int arrayLen, ByteBuffer bb) {
        Object[] elements = ArrayType.createArray(elementType.clazz, arrayLen);
        byte[] unitBuffer = ABIType.newUnitBuffer();
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = elementType.decode(bb, unitBuffer);
        }
        return elements;
    }

    private static Object[] decodeObjectArray(ABIType<Object> elementType, int arrayLen, ByteBuffer bb) {
        Object[] objects = ArrayType.createArray(elementType.clazz, arrayLen);
        for (int i = 0; i < objects.length; ++i) {
            objects[i] = PackedDecoder.decode(elementType, bb, -1);
        }
        return objects;
    }

    private static long decodeLong(UnitType<? extends Number> type, ByteBuffer bb, int len) {
        long val = PackedDecoder.decodeSignedLong(bb, len);
        if (type.unsigned) {
            return new Uint(type.bitLength).toUnsignedLong(val);
        }
        return val;
    }

    private static long decodeSignedLong(ByteBuffer bb, int len) {
        return PackedDecoder.getSignedBigInt(bb, len).longValueExact();
    }
}

