/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategies;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallAddressChecks;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallAttemptOptions;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallFactory;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.CallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.SyntheticIds;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.MessageFrame;

@Singleton
public class HssCallFactory
implements CallFactory<HssCallAttempt> {
    private final SyntheticIds syntheticIds;
    private final CallAddressChecks addressChecks;
    private final VerificationStrategies verificationStrategies;
    private final SignatureVerifier signatureVerifier;
    private final List<CallTranslator<HssCallAttempt>> callTranslators;
    private final SystemContractMethodRegistry systemContractMethodRegistry;

    @Inject
    public HssCallFactory(@NonNull SyntheticIds syntheticIds, @NonNull CallAddressChecks addressChecks, @NonNull VerificationStrategies verificationStrategies, @NonNull SignatureVerifier signatureVerifier, @Named(value="HssTranslators") @NonNull List<CallTranslator<HssCallAttempt>> callTranslators, @NonNull SystemContractMethodRegistry systemContractMethodRegistry) {
        this.syntheticIds = Objects.requireNonNull(syntheticIds);
        this.addressChecks = Objects.requireNonNull(addressChecks);
        this.verificationStrategies = Objects.requireNonNull(verificationStrategies);
        this.signatureVerifier = Objects.requireNonNull(signatureVerifier);
        this.callTranslators = Objects.requireNonNull(callTranslators);
        this.systemContractMethodRegistry = Objects.requireNonNull(systemContractMethodRegistry);
    }

    @Override
    @NonNull
    public HssCallAttempt createCallAttemptFrom(@NonNull ContractID contractID, @NonNull Bytes input, @NonNull FrameUtils.CallType callType, @NonNull MessageFrame frame) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(frame);
        HederaWorldUpdater.Enhancement enhancement = FrameUtils.proxyUpdaterFor(frame).enhancement();
        return new HssCallAttempt(input, new CallAttemptOptions<HssCallAttempt>(contractID, frame.getSenderAddress(), frame.getSenderAddress(), this.addressChecks.hasParentDelegateCall(frame), enhancement, FrameUtils.configOf(frame), this.syntheticIds.converterFor(enhancement.nativeOperations()), this.verificationStrategies, FrameUtils.systemContractGasCalculatorOf(frame), this.callTranslators, this.systemContractMethodRegistry, frame.isStatic()), this.signatureVerifier);
    }
}

