/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class PrettyStringBuilder {
    private final int maxArrayLen;
    private final int maxDeep;
    private final String nullValue;
    private int deep;

    public PrettyStringBuilder() {
        this.maxArrayLen = 10;
        this.maxDeep = 3;
        this.nullValue = "<null>";
    }

    public PrettyStringBuilder(int maxArrayLen, int maxDeep, String nullValue) {
        this.maxArrayLen = maxArrayLen;
        this.maxDeep = maxDeep;
        this.nullValue = nullValue;
    }

    protected String toPrettyString(Object obj) {
        ++this.deep;
        if (obj == null) {
            --this.deep;
            return this.nullValue;
        }
        if (this.deep == this.maxDeep) {
            --this.deep;
            return obj.toString();
        }
        StringBuilder s = new StringBuilder();
        Class<?> c = obj.getClass();
        if (c.isArray()) {
            int arrayLen = Array.getLength(obj);
            int len = Math.min(arrayLen, this.maxArrayLen);
            s.append('[');
            for (int i = 0; i < len; ++i) {
                s.append(this.toPrettyString(Array.get(obj, i)));
                if (i == len - 1) continue;
                s.append(',');
            }
            if (len < arrayLen) {
                s.append("...");
            }
            s.append(']');
        } else if (obj instanceof Collection) {
            int i;
            Collection coll = (Collection)obj;
            Iterator it = coll.iterator();
            s.append('(');
            for (i = 0; it.hasNext() && i < this.maxArrayLen; ++i) {
                s.append(this.toPrettyString(it.next()));
            }
            if (i < coll.size()) {
                s.append("...");
            }
            s.append(')');
        } else if (obj instanceof Map) {
            int i;
            Map map = (Map)obj;
            Iterator it = map.keySet().iterator();
            s.append('{');
            for (i = 0; it.hasNext() && i < this.maxArrayLen; ++i) {
                Object key = it.next();
                s.append(key).append(':');
                s.append(this.toPrettyString(map.get(key)));
            }
            if (i < map.size()) {
                s.append("...");
            }
            s.append('}');
        } else {
            s.append(obj.toString());
        }
        --this.deep;
        return s.toString();
    }

    public String toString(Object value) {
        return this.toPrettyString(value);
    }
}

