/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.dispatch;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.workflows.handle.dispatch.DispatchValidator;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record ValidationResult(@NonNull AccountID creatorId, @Nullable ResponseCodeEnum creatorError, @Nullable Account payer, @Nullable ResponseCodeEnum payerError, @NonNull DispatchValidator.ServiceFeeStatus serviceFeeStatus, @NonNull DispatchValidator.DuplicateStatus duplicateStatus) implements FeeCharging.Validation
{
    public boolean creatorDidDueDiligence() {
        return this.creatorError == null;
    }

    @Nullable
    public ResponseCodeEnum maybeErrorStatus() {
        return this.creatorError != null ? this.creatorError : this.payerError;
    }

    @NonNull
    public static ValidationResult newCreatorError(@NonNull AccountID creatorId, @NonNull ResponseCodeEnum creatorError) {
        return new ValidationResult(creatorId, creatorError, null, null, DispatchValidator.ServiceFeeStatus.CAN_PAY_SERVICE_FEE, DispatchValidator.DuplicateStatus.NO_DUPLICATE);
    }

    @NonNull
    public static ValidationResult newPayerDuplicateError(@NonNull AccountID creatorId, @NonNull Account payer) {
        Objects.requireNonNull(payer);
        Objects.requireNonNull(creatorId);
        return new ValidationResult(creatorId, null, payer, ResponseCodeEnum.DUPLICATE_TRANSACTION, DispatchValidator.ServiceFeeStatus.CAN_PAY_SERVICE_FEE, DispatchValidator.DuplicateStatus.DUPLICATE);
    }

    @NonNull
    public static ValidationResult newPayerUniqueError(@NonNull AccountID creatorId, @NonNull Account payer, @NonNull ResponseCodeEnum payerError) {
        Objects.requireNonNull(payer);
        Objects.requireNonNull(creatorId);
        Objects.requireNonNull(payerError);
        return new ValidationResult(creatorId, null, payer, payerError, DispatchValidator.ServiceFeeStatus.CAN_PAY_SERVICE_FEE, DispatchValidator.DuplicateStatus.NO_DUPLICATE);
    }

    public static ValidationResult newPayerError(@NonNull AccountID creatorId, @NonNull Account payer, @NonNull ResponseCodeEnum payerError, @NonNull DispatchValidator.ServiceFeeStatus serviceFeeStatus, boolean isDuplicate) {
        return new ValidationResult(creatorId, null, payer, payerError, serviceFeeStatus, isDuplicate ? DispatchValidator.DuplicateStatus.DUPLICATE : DispatchValidator.DuplicateStatus.NO_DUPLICATE);
    }

    @NonNull
    public static ValidationResult newPayerError(@NonNull AccountID creatorId, @NonNull Account payer, @NonNull ResponseCodeEnum payerError, @NonNull DispatchValidator.ServiceFeeStatus serviceFeeStatus, @NonNull DispatchValidator.DuplicateStatus duplicateStatus) {
        return new ValidationResult(creatorId, null, payer, payerError, serviceFeeStatus, duplicateStatus);
    }

    @NonNull
    public static ValidationResult newSuccess(@NonNull AccountID creatorId, @NonNull Account payer) {
        Objects.requireNonNull(creatorId);
        Objects.requireNonNull(payer);
        return new ValidationResult(creatorId, null, payer, null, DispatchValidator.ServiceFeeStatus.CAN_PAY_SERVICE_FEE, DispatchValidator.DuplicateStatus.NO_DUPLICATE);
    }

    @NonNull
    public static ValidationResult newSuccess(@NonNull AccountID creatorId) {
        Objects.requireNonNull(creatorId);
        return new ValidationResult(creatorId, null, null, null, DispatchValidator.ServiceFeeStatus.CAN_PAY_SERVICE_FEE, DispatchValidator.DuplicateStatus.NO_DUPLICATE);
    }

    @NonNull
    public static ValidationResult newGenesisWaiver(@NonNull AccountID creatorId) {
        Objects.requireNonNull(creatorId);
        return new ValidationResult(creatorId, null, null, null, DispatchValidator.ServiceFeeStatus.CAN_PAY_SERVICE_FEE, DispatchValidator.DuplicateStatus.NO_DUPLICATE);
    }

    public boolean isSuccess() {
        return this.creatorError == null && this.payerError == null;
    }

    public boolean isCreatorError() {
        return this.creatorError != null;
    }

    public boolean isPayerError() {
        return this.payerError != null;
    }

    @NonNull
    public ResponseCodeEnum payerErrorOrThrow() {
        return Objects.requireNonNull(this.payerError);
    }

    @NonNull
    public ResponseCodeEnum creatorErrorOrThrow() {
        return Objects.requireNonNull(this.creatorError);
    }

    @NonNull
    public ValidationResult withoutServiceFee() {
        return new ValidationResult(this.creatorId, this.creatorError, this.payer, this.payerError, DispatchValidator.ServiceFeeStatus.UNABLE_TO_PAY_SERVICE_FEE, this.duplicateStatus);
    }
}

