/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.infra;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.contract.ContractCallLocalQuery;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.node.app.service.contract.impl.annotations.QueryScope;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransaction;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.ValidationUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;

@QueryScope
public class HevmStaticTransactionFactory {
    private static final long INTRINSIC_GAS_LOWER_BOUND = 21000L;
    private final ContractsConfig contractsConfig;
    private final GasCalculator gasCalculator;
    private final QueryContext context;
    private final AccountID payerId;

    @Inject
    public HevmStaticTransactionFactory(@NonNull QueryContext context, @NonNull GasCalculator gasCalculator) {
        this.context = Objects.requireNonNull(context);
        this.contractsConfig = (ContractsConfig)context.configuration().getConfigData(ContractsConfig.class);
        this.gasCalculator = Objects.requireNonNull(gasCalculator);
        this.payerId = Objects.requireNonNull(context.payer());
    }

    @NonNull
    public HederaEvmTransaction fromHapiQuery(@NonNull Query query) {
        ContractCallLocalQuery op = query.contractCallLocalOrThrow();
        this.assertValidCall(op);
        AccountID senderId = op.hasSenderId() ? op.senderIdOrThrow() : this.payerId;
        ContractID targetId = ConversionUtils.asPriorityId(op.contractIDOrThrow(), (ReadableAccountStore)this.context.createStore(ReadableAccountStore.class));
        return new HederaEvmTransaction(senderId, null, targetId, -1L, op.functionParameters(), null, 0L, op.gas(), 1L, 0L, null, null, null);
    }

    @NonNull
    public HederaEvmTransaction fromHapiQueryException(@NonNull Query query, @NonNull HandleException exception) {
        ContractCallLocalQuery op = query.contractCallLocalOrThrow();
        AccountID senderId = op.hasSenderId() ? op.senderIdOrThrow() : this.payerId;
        ContractID targetId = ConversionUtils.asPriorityId(op.contractIDOrThrow(), (ReadableAccountStore)this.context.createStore(ReadableAccountStore.class));
        return new HederaEvmTransaction(senderId, null, targetId, -1L, op.functionParameters(), null, 0L, op.gas(), 1L, 0L, null, exception, null);
    }

    private void assertValidCall(@NonNull ContractCallLocalQuery body) {
        long minGasLimit = Math.max(21000L, this.gasCalculator.transactionIntrinsicGasCost(Bytes.EMPTY, false, 0L));
        HandleException.validateTrue((body.gas() >= minGasLimit ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INSUFFICIENT_GAS);
        HandleException.validateTrue((body.gas() <= ValidationUtils.getMaxGasLimit(this.contractsConfig) ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_GAS_LIMIT_EXCEEDED);
    }
}

