/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.schemas;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.state.contract.SlotKey;
import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.platform.state.StateKey;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;

public class V0490ContractSchema
extends Schema<SemanticVersion> {
    private static final int MAX_BYTECODES = 50000;
    private static final int MAX_STORAGE_ENTRIES = 1000000;
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(49).patch(0).build();
    public static final String STORAGE_KEY = "STORAGE";
    public static final int STORAGE_STATE_ID = StateKey.KeyOneOfType.CONTRACTSERVICE_I_STORAGE.protoOrdinal();
    public static final String BYTECODE_KEY = "BYTECODE";
    public static final int BYTECODE_STATE_ID = StateKey.KeyOneOfType.CONTRACTSERVICE_I_BYTECODE.protoOrdinal();

    public V0490ContractSchema() {
        super((Object)VERSION, HapiUtils.SEMANTIC_VERSION_COMPARATOR);
    }

    public void migrate(@NonNull MigrationContext ctx) {
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(this.storageDef(), this.bytecodeDef());
    }

    @NonNull
    private StateDefinition<SlotKey, SlotValue> storageDef() {
        return StateDefinition.onDisk((int)STORAGE_STATE_ID, (String)STORAGE_KEY, (Codec)SlotKey.PROTOBUF, (Codec)SlotValue.PROTOBUF, (long)1000000L);
    }

    @NonNull
    private StateDefinition<ContractID, Bytecode> bytecodeDef() {
        return StateDefinition.onDisk((int)BYTECODE_STATE_ID, (String)BYTECODE_KEY, (Codec)ContractID.PROTOBUF, (Codec)Bytecode.PROTOBUF, (long)50000L);
    }
}

