/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.ModuleInfoUsesBlueprint;
import io.helidon.common.types.TypeName;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ModuleInfoUses
extends ModuleInfoUsesBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ModuleInfoUses instance) {
        return (Builder)ModuleInfoUses.builder().from(instance);
    }

    public static ModuleInfoUses create() {
        return ModuleInfoUses.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ModuleInfoUses>
    implements io.helidon.common.Builder<Builder, ModuleInfoUses> {
        private Builder() {
        }

        public ModuleInfoUses buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ModuleInfoUsesImpl(this);
        }

        public ModuleInfoUses build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ModuleInfoUses>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private TypeName service;

        protected BuilderBase() {
        }

        public BUILDER from(ModuleInfoUses prototype) {
            this.service(prototype.service());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.service().ifPresent(this::service);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(TypeName service) {
            Objects.requireNonNull(service);
            this.service = service;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.service(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER service(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.service(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<TypeName> service() {
            return Optional.ofNullable(this.service);
        }

        public String toString() {
            return "ModuleInfoUsesBuilder{service=" + String.valueOf(this.service) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.service == null) {
                collector.fatal(this.getClass(), "Property \"service\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class ModuleInfoUsesImpl
        implements ModuleInfoUses {
            private final TypeName service;

            protected ModuleInfoUsesImpl(BuilderBase<?, ?> builder) {
                this.service = builder.service().get();
            }

            @Override
            public TypeName service() {
                return this.service;
            }

            public String toString() {
                return "ModuleInfoUses{service=" + String.valueOf(this.service) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ModuleInfoUses)) {
                    return false;
                }
                ModuleInfoUses other = (ModuleInfoUses)o;
                return Objects.equals(this.service, other.service());
            }

            public int hashCode() {
                return Objects.hash(this.service);
            }
        }
    }
}

