/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.buffers.Ascii;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNameEnum;
import io.helidon.http.HeaderNameImpl;

public final class HeaderNames {
    public static final String ACCEPT_NAME = "Accept";
    public static final HeaderName ACCEPT = HeaderNameEnum.ACCEPT;
    public static final String ACCEPT_CHARSET_NAME = "Accept-Charset";
    public static final HeaderName ACCEPT_CHARSET = HeaderNameEnum.ACCEPT_CHARSET;
    public static final String ACCEPT_ENCODING_NAME = "Accept-Encoding";
    public static final HeaderName ACCEPT_ENCODING = HeaderNameEnum.ACCEPT_ENCODING;
    public static final String ACCEPT_LANGUAGE_NAME = "Accept-Language";
    public static final HeaderName ACCEPT_LANGUAGE = HeaderNameEnum.ACCEPT_LANGUAGE;
    public static final String ACCEPT_DATETIME_NAME = "Accept-Datetime";
    public static final HeaderName ACCEPT_DATETIME = HeaderNameEnum.ACCEPT_DATETIME;
    public static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_NAME = "Access-Control-Allow-Credentials";
    public static final HeaderName ACCESS_CONTROL_ALLOW_CREDENTIALS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_CREDENTIALS;
    public static final String ACCESS_CONTROL_ALLOW_HEADERS_NAME = "Access-Control-Allow-Headers";
    public static final HeaderName ACCESS_CONTROL_ALLOW_HEADERS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_HEADERS;
    public static final String ACCESS_CONTROL_ALLOW_METHODS_NAME = "Access-Control-Allow-Methods";
    public static final HeaderName ACCESS_CONTROL_ALLOW_METHODS = HeaderNameEnum.ACCESS_CONTROL_ALLOW_METHODS;
    public static final String ACCESS_CONTROL_ALLOW_ORIGIN_NAME = "Access-Control-Allow-Origin";
    public static final HeaderName ACCESS_CONTROL_ALLOW_ORIGIN = HeaderNameEnum.ACCESS_CONTROL_ALLOW_ORIGIN;
    public static final String ACCESS_CONTROL_EXPOSE_HEADERS_NAME = "Access-Control-Expose-Headers";
    public static final HeaderName ACCESS_CONTROL_EXPOSE_HEADERS = HeaderNameEnum.ACCESS_CONTROL_EXPOSE_HEADERS;
    public static final String ACCESS_CONTROL_MAX_AGE_NAME = "Access-Control-Max-Age";
    public static final HeaderName ACCESS_CONTROL_MAX_AGE = HeaderNameEnum.ACCESS_CONTROL_MAX_AGE;
    public static final String ACCESS_CONTROL_REQUEST_HEADERS_NAME = "Access-Control-Request-Headers";
    public static final HeaderName ACCESS_CONTROL_REQUEST_HEADERS = HeaderNameEnum.ACCESS_CONTROL_REQUEST_HEADERS;
    public static final String ACCESS_CONTROL_REQUEST_METHOD_NAME = "Access-Control-Request-Method";
    public static final HeaderName ACCESS_CONTROL_REQUEST_METHOD = HeaderNameEnum.ACCESS_CONTROL_REQUEST_METHOD;
    public static final String AUTHORIZATION_NAME = "Authorization";
    public static final HeaderName AUTHORIZATION = HeaderNameEnum.AUTHORIZATION;
    public static final String COOKIE_NAME = "Cookie";
    public static final HeaderName COOKIE = HeaderNameEnum.COOKIE;
    public static final String EXPECT_NAME = "Expect";
    public static final HeaderName EXPECT = HeaderNameEnum.EXPECT;
    public static final String FORWARDED_NAME = "Forwarded";
    public static final HeaderName FORWARDED = HeaderNameEnum.FORWARDED;
    public static final String FROM_NAME = "From";
    public static final HeaderName FROM = HeaderNameEnum.FROM;
    public static final String HOST_NAME = "Host";
    public static final HeaderName HOST = HeaderNameEnum.HOST;
    public static final String IF_MATCH_NAME = "If-Match";
    public static final HeaderName IF_MATCH = HeaderNameEnum.IF_MATCH;
    public static final String IF_MODIFIED_SINCE_NAME = "If-Modified-Since";
    public static final HeaderName IF_MODIFIED_SINCE = HeaderNameEnum.IF_MODIFIED_SINCE;
    public static final String IF_NONE_MATCH_NAME = "If-None-Match";
    public static final HeaderName IF_NONE_MATCH = HeaderNameEnum.IF_NONE_MATCH;
    public static final String IF_RANGE_NAME = "If-Range";
    public static final HeaderName IF_RANGE = HeaderNameEnum.IF_RANGE;
    public static final String IF_UNMODIFIED_SINCE_NAME = "If-Unmodified-Since";
    public static final HeaderName IF_UNMODIFIED_SINCE = HeaderNameEnum.IF_UNMODIFIED_SINCE;
    public static final String MAX_FORWARDS_NAME = "Max-Forwards";
    public static final HeaderName MAX_FORWARDS = HeaderNameEnum.MAX_FORWARDS;
    public static final String ORIGIN_NAME = "Origin";
    public static final HeaderName ORIGIN = HeaderNameEnum.ORIGIN;
    public static final String PROXY_AUTHENTICATE_NAME = "Proxy-Authenticate";
    public static final HeaderName PROXY_AUTHENTICATE = HeaderNameEnum.PROXY_AUTHENTICATE;
    public static final String PROXY_AUTHORIZATION_NAME = "Proxy-Authorization";
    public static final HeaderName PROXY_AUTHORIZATION = HeaderNameEnum.PROXY_AUTHORIZATION;
    public static final String RANGE_NAME = "Range";
    public static final HeaderName RANGE = HeaderNameEnum.RANGE;
    public static final String REFERER_NAME = "Referer";
    public static final HeaderName REFERER = HeaderNameEnum.REFERER;
    public static final String REFRESH_NAME = "Refresh";
    public static final HeaderName REFRESH = HeaderNameEnum.REFRESH;
    public static final String TE_NAME = "TE";
    public static final HeaderName TE = HeaderNameEnum.TE;
    public static final String USER_AGENT_NAME = "User-Agent";
    public static final HeaderName USER_AGENT = HeaderNameEnum.USER_AGENT;
    public static final String VIA_NAME = "Via";
    public static final HeaderName VIA = HeaderNameEnum.VIA;
    public static final String ACCEPT_PATCH_NAME = "Accept-Patch";
    public static final HeaderName ACCEPT_PATCH = HeaderNameEnum.ACCEPT_PATCH;
    public static final String ACCEPT_RANGES_NAME = "Accept-Ranges";
    public static final HeaderName ACCEPT_RANGES = HeaderNameEnum.ACCEPT_RANGES;
    public static final String AGE_NAME = "Age";
    public static final HeaderName AGE = HeaderNameEnum.AGE;
    public static final String ALLOW_NAME = "Allow";
    public static final HeaderName ALLOW = HeaderNameEnum.ALLOW;
    public static final String ALT_SVC_NAME = "Alt-Svc";
    public static final HeaderName ALT_SVC = HeaderNameEnum.ALT_SVC;
    public static final String CACHE_CONTROL_NAME = "Cache-Control";
    public static final HeaderName CACHE_CONTROL = HeaderNameEnum.CACHE_CONTROL;
    public static final String CONNECTION_NAME = "Connection";
    public static final HeaderName CONNECTION = HeaderNameEnum.CONNECTION;
    public static final String CONTENT_DISPOSITION_NAME = "Content-Disposition";
    public static final HeaderName CONTENT_DISPOSITION = HeaderNameEnum.CONTENT_DISPOSITION;
    public static final String CONTENT_ENCODING_NAME = "Content-Encoding";
    public static final HeaderName CONTENT_ENCODING = HeaderNameEnum.CONTENT_ENCODING;
    public static final String CONTENT_LANGUAGE_NAME = "Content-Language";
    public static final HeaderName CONTENT_LANGUAGE = HeaderNameEnum.CONTENT_LANGUAGE;
    public static final String CONTENT_LENGTH_NAME = "Content-Length";
    public static final HeaderName CONTENT_LENGTH = HeaderNameEnum.CONTENT_LENGTH;
    public static final String CONTENT_LOCATION_NAME = "aa";
    public static final HeaderName CONTENT_LOCATION = HeaderNameEnum.CONTENT_LOCATION;
    public static final String CONTENT_RANGE_NAME = "Content-Range";
    public static final HeaderName CONTENT_RANGE = HeaderNameEnum.CONTENT_RANGE;
    public static final String CONTENT_TYPE_NAME = "Content-Type";
    public static final HeaderName CONTENT_TYPE = HeaderNameEnum.CONTENT_TYPE;
    public static final String DATE_NAME = "Date";
    public static final HeaderName DATE = HeaderNameEnum.DATE;
    public static final String ETAG_NAME = "ETag";
    public static final HeaderName ETAG = HeaderNameEnum.ETAG;
    public static final String EXPIRES_NAME = "Expires";
    public static final HeaderName EXPIRES = HeaderNameEnum.EXPIRES;
    public static final String LAST_MODIFIED_NAME = "Last-Modified";
    public static final HeaderName LAST_MODIFIED = HeaderNameEnum.LAST_MODIFIED;
    public static final String LINK_NAME = "Link";
    public static final HeaderName LINK = HeaderNameEnum.LINK;
    public static final String LOCATION_NAME = "Location";
    public static final HeaderName LOCATION = HeaderNameEnum.LOCATION;
    public static final String PRAGMA_NAME = "Pragma";
    public static final HeaderName PRAGMA = HeaderNameEnum.PRAGMA;
    public static final String PUBLIC_KEY_PINS_NAME = "Public-Key-Pins";
    public static final HeaderName PUBLIC_KEY_PINS = HeaderNameEnum.PUBLIC_KEY_PINS;
    public static final String RETRY_AFTER_NAME = "Retry-After";
    public static final HeaderName RETRY_AFTER = HeaderNameEnum.RETRY_AFTER;
    public static final String SERVER_NAME = "Server";
    public static final HeaderName SERVER = HeaderNameEnum.SERVER;
    public static final String SET_COOKIE_NAME = "Set-Cookie";
    public static final HeaderName SET_COOKIE = HeaderNameEnum.SET_COOKIE;
    public static final String SET_COOKIE2_NAME = "Set-Cookie2";
    public static final HeaderName SET_COOKIE2 = HeaderNameEnum.SET_COOKIE2;
    public static final String STRICT_TRANSPORT_SECURITY_NAME = "Strict-Transport-Security";
    public static final HeaderName STRICT_TRANSPORT_SECURITY = HeaderNameEnum.STRICT_TRANSPORT_SECURITY;
    public static final String TRAILER_NAME = "Trailer";
    public static final HeaderName TRAILER = HeaderNameEnum.TRAILER;
    public static final String TRANSFER_ENCODING_NAME = "Transfer-Encoding";
    public static final HeaderName TRANSFER_ENCODING = HeaderNameEnum.TRANSFER_ENCODING;
    public static final String TSV_NAME = "TSV";
    public static final HeaderName TSV = HeaderNameEnum.TSV;
    public static final String UPGRADE_NAME = "Upgrade";
    public static final HeaderName UPGRADE = HeaderNameEnum.UPGRADE;
    public static final String VARY_NAME = "Vary";
    public static final HeaderName VARY = HeaderNameEnum.VARY;
    public static final String WARNING_NAME = "Warning";
    public static final HeaderName WARNING = HeaderNameEnum.WARNING;
    public static final String WWW_AUTHENTICATE_NAME = "WWW-Authenticate";
    public static final HeaderName WWW_AUTHENTICATE = HeaderNameEnum.WWW_AUTHENTICATE;
    public static final String X_HELIDON_CN_NAME = "X-HELIDON-CN";
    public static final HeaderName X_HELIDON_CN = HeaderNameEnum.X_HELIDON_CN;
    public static final String X_FORWARDED_FOR_NAME = "X-Forwarded-For";
    public static final HeaderName X_FORWARDED_FOR = HeaderNameEnum.X_FORWARDED_FOR;
    public static final String X_FORWARDED_HOST_NAME = "X-Forwarded-Host";
    public static final HeaderName X_FORWARDED_HOST = HeaderNameEnum.X_FORWARDED_HOST;
    public static final String X_FORWARDED_PORT_NAME = "X-Forwarded-Port";
    public static final HeaderName X_FORWARDED_PORT = HeaderNameEnum.X_FORWARDED_PORT;
    public static final String X_FORWARDED_PREFIX_NAME = "X-Forwarded-Prefix";
    public static final HeaderName X_FORWARDED_PREFIX = HeaderNameEnum.X_FORWARDED_PREFIX;
    public static final String X_FORWARDED_PROTO_NAME = "X-Forwarded-Proto";
    public static final HeaderName X_FORWARDED_PROTO = HeaderNameEnum.X_FORWARDED_PROTO;
    public static final String X_CONTENT_TYPE_OPTIONS_NAME = "X-Content-Type-Options";
    public static final HeaderName X_CONTENT_TYPE_OPTIONS = HeaderNameEnum.X_CONTENT_TYPE_OPTIONS;

    private HeaderNames() {
    }

    public static HeaderName create(String name) {
        HeaderName headerName = HeaderNameEnum.byCapitalizedName(name);
        if (headerName == null) {
            return new HeaderNameImpl(Ascii.toLowerCase((String)name), name);
        }
        return headerName;
    }

    public static HeaderName create(String lowerCase, String defaultCase) {
        HeaderName headerName = HeaderNameEnum.byName(lowerCase);
        if (headerName == null) {
            return new HeaderNameImpl(lowerCase, defaultCase);
        }
        return headerName;
    }

    public static HeaderName createFromLowercase(String lowerCase) {
        HeaderName headerName = HeaderNameEnum.byName(lowerCase);
        if (headerName == null) {
            return new HeaderNameImpl(lowerCase, lowerCase);
        }
        return headerName;
    }
}

