/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ByteStringUtils {
    private static final Logger log = LogManager.getLogger(ByteStringUtils.class);

    public static ByteString wrapUnsafely(@NonNull byte[] bytes) {
        return UnsafeByteOperations.unsafeWrap((byte[])bytes);
    }

    public static byte[] unwrapUnsafelyIfPossible(@NonNull ByteString byteString) {
        if (UnsafeByteOutput.supports(byteString)) {
            return ByteStringUtils.internalUnwrap(byteString, new UnsafeByteOutput());
        }
        return byteString.toByteArray();
    }

    static byte[] internalUnwrap(ByteString byteString, UnsafeByteOutput byteOutput) {
        try {
            UnsafeByteOperations.unsafeWriteTo((ByteString)byteString, (ByteOutput)byteOutput);
            return byteOutput.bytes;
        }
        catch (IOException e) {
            log.warn("Unsafe retrieval of bytes failed", (Throwable)e);
            return byteString.toByteArray();
        }
    }

    private ByteStringUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    static class UnsafeByteOutput
    extends ByteOutput {
        static final short SIZE = 16;
        static final Function<String, Class<?>> CLASS_BY_NAME = name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        };
        private static final String SUPPORTED_NAME = ByteString.class.getName() + "$LiteralByteString";
        private static final Class<?> SUPPORTED_CLASS = CLASS_BY_NAME.apply(SUPPORTED_NAME);
        private byte[] bytes;

        UnsafeByteOutput() {
        }

        public void write(byte value) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void write(byte[] bytes, int offset, int length) throws IOException {
            this.bytes = bytes;
        }

        public void write(ByteBuffer value) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void writeLazy(byte[] bytes, int offset, int length) {
            this.bytes = bytes;
        }

        public void writeLazy(ByteBuffer value) {
            throw new UnsupportedOperationException();
        }

        @VisibleForTesting
        byte[] getBytes() {
            return this.bytes;
        }

        @VisibleForTesting
        static boolean supports(ByteString byteString) {
            return byteString.size() > 16 && SUPPORTED_CLASS.equals(byteString.getClass());
        }
    }
}

